/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client;

import com.mojang.logging.LogUtils;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import liedge.limacore.client.LimaFluidClientExtensions;
import liedge.limacore.client.particle.LimaParticleUtil;
import liedge.limacore.lib.LimaColor;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.client.LTXIClientRecipes;
import liedge.ltxindustries.client.LTXIItemOverrides;
import liedge.ltxindustries.client.LTXIKeyMappings;
import liedge.ltxindustries.client.gui.ClientFabricatorIngredientTooltip;
import liedge.ltxindustries.client.gui.ClientItemGridTooltip;
import liedge.ltxindustries.client.gui.UpgradeIconSprites;
import liedge.ltxindustries.client.gui.layer.BubbleShieldLayer;
import liedge.ltxindustries.client.gui.layer.WeaponCrosshairLayer;
import liedge.ltxindustries.client.gui.layer.WeaponHUDInfoLayer;
import liedge.ltxindustries.client.gui.screen.AutoFabricatorScreen;
import liedge.ltxindustries.client.gui.screen.BlockIOConfigurationScreen;
import liedge.ltxindustries.client.gui.screen.EnergyCellArrayScreen;
import liedge.ltxindustries.client.gui.screen.EquipmentUpgradeStationScreen;
import liedge.ltxindustries.client.gui.screen.FabricatorScreen;
import liedge.ltxindustries.client.gui.screen.MachineUpgradesScreen;
import liedge.ltxindustries.client.gui.screen.MolecularReconstructorScreen;
import liedge.ltxindustries.client.gui.screen.RecipeLayoutScreen;
import liedge.ltxindustries.client.gui.screen.RecipeModeScreen;
import liedge.ltxindustries.client.gui.screen.TurretScreen;
import liedge.ltxindustries.client.model.baked.EmissiveBiLayerGeometry;
import liedge.ltxindustries.client.model.custom.BubbleShieldModel;
import liedge.ltxindustries.client.model.entity.GlowstickProjectileModel;
import liedge.ltxindustries.client.model.entity.LTXIModelLayers;
import liedge.ltxindustries.client.model.entity.OrbGrenadeModel;
import liedge.ltxindustries.client.model.entity.RocketModel;
import liedge.ltxindustries.client.particle.AcidDripParticle;
import liedge.ltxindustries.client.particle.AnimatedGlowParticle;
import liedge.ltxindustries.client.particle.BigColorSmokeParticle;
import liedge.ltxindustries.client.particle.ColorFlashParticle;
import liedge.ltxindustries.client.particle.ColorSonicBoomParticle;
import liedge.ltxindustries.client.particle.FixedElectricBoltParticle;
import liedge.ltxindustries.client.particle.GrenadeExplosionParticle;
import liedge.ltxindustries.client.particle.GroundIcicleParticle;
import liedge.ltxindustries.client.particle.LightfragTracerParticle;
import liedge.ltxindustries.client.particle.RailgunBoltParticle;
import liedge.ltxindustries.client.renderer.blockentity.BaseFabricatorRenderer;
import liedge.ltxindustries.client.renderer.blockentity.DigitalGardenRenderer;
import liedge.ltxindustries.client.renderer.blockentity.ElectroCentrifugeRenderer;
import liedge.ltxindustries.client.renderer.blockentity.EnergyCellArrayRenderer;
import liedge.ltxindustries.client.renderer.blockentity.EquipmentUpgradeStationRenderer;
import liedge.ltxindustries.client.renderer.blockentity.MixerRenderer;
import liedge.ltxindustries.client.renderer.blockentity.RailgunTurretRenderer;
import liedge.ltxindustries.client.renderer.blockentity.RocketTurretRenderer;
import liedge.ltxindustries.client.renderer.entity.GlowstickProjectileRenderer;
import liedge.ltxindustries.client.renderer.entity.OrbGrenadeRenderer;
import liedge.ltxindustries.client.renderer.entity.RocketRenderer;
import liedge.ltxindustries.client.renderer.entity.StickyFlameRenderer;
import liedge.ltxindustries.client.renderer.item.BlueprintItemExtensions;
import liedge.ltxindustries.client.renderer.item.LTXIItemRenderers;
import liedge.ltxindustries.client.renderer.item.UpgradeModuleItemExtensions;
import liedge.ltxindustries.menu.tooltip.FabricatorIngredientTooltip;
import liedge.ltxindustries.menu.tooltip.ItemGridTooltip;
import liedge.ltxindustries.registry.game.LTXIBlockEntities;
import liedge.ltxindustries.registry.game.LTXIBlocks;
import liedge.ltxindustries.registry.game.LTXIEntities;
import liedge.ltxindustries.registry.game.LTXIFluids;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXIMenus;
import liedge.ltxindustries.registry.game.LTXIParticles;
import liedge.ltxindustries.registry.game.LTXIRecipeTypes;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterRecipeBookCategoriesEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.slf4j.Logger;

@Mod(value="ltxi", dist={Dist.CLIENT})
public class LTXIndustriesClient {
    public static final Logger CLIENT_LOGGER = LogUtils.getLogger();

    public LTXIndustriesClient(IEventBus modBus, ModContainer modContainer) {
        modBus.register((Object)new ClientSetup());
    }

    private static class ClientSetup {
        private ClientSetup() {
        }

        @SubscribeEvent
        public void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(LTXIItemOverrides::registerOverrides);
            Stream.of(LTXIFluids.VIRIDIC_ACID, LTXIFluids.FLOWING_VIRIDIC_ACID, LTXIFluids.HYDROGEN, LTXIFluids.FLOWING_HYDROGEN, LTXIFluids.OXYGEN, LTXIFluids.FLOWING_OXYGEN).map(DeferredHolder::value).forEach(fluid -> ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (RenderType)RenderType.translucent()));
        }

        @SubscribeEvent
        public void registerRecipeBookCategories(RegisterRecipeBookCategoriesEvent event) {
            event.registerRecipeCategoryFinder((RecipeType)LTXIRecipeTypes.FABRICATING.get(), $ -> (RecipeBookCategories)LTXIClientRecipes.FABRICATING_CATEGORY.getValue());
        }

        @SubscribeEvent
        public void registerClientExtensions(RegisterClientExtensionsEvent event) {
            event.registerItem((IClientItemExtensions)UpgradeModuleItemExtensions.getInstance(), new Item[]{(Item)LTXIItems.EQUIPMENT_UPGRADE_MODULE.get(), (Item)LTXIItems.MACHINE_UPGRADE_MODULE.get()});
            event.registerItem((IClientItemExtensions)BlueprintItemExtensions.INSTANCE, new Holder[]{LTXIItems.FABRICATION_BLUEPRINT});
            event.registerItem((IClientItemExtensions)LTXIItemRenderers.GLOWSTICK_LAUNCHER, new Item[]{(Item)LTXIItems.GLOWSTICK_LAUNCHER.get()});
            event.registerItem((IClientItemExtensions)LTXIItemRenderers.SUBMACHINE_GUN, new Item[]{(Item)LTXIItems.SUBMACHINE_GUN.get()});
            event.registerItem((IClientItemExtensions)LTXIItemRenderers.SHOTGUN, new Item[]{(Item)LTXIItems.SHOTGUN.get()});
            event.registerItem((IClientItemExtensions)LTXIItemRenderers.GRENADE_LAUNCHER, new Item[]{(Item)LTXIItems.GRENADE_LAUNCHER.get()});
            event.registerItem((IClientItemExtensions)LTXIItemRenderers.LINEAR_FUSION_RIFLE, new Item[]{(Item)LTXIItems.LINEAR_FUSION_RIFLE.get()});
            event.registerItem((IClientItemExtensions)LTXIItemRenderers.ROCKET_LAUNCHER, new Item[]{(Item)LTXIItems.ROCKET_LAUNCHER.get()});
            event.registerItem((IClientItemExtensions)LTXIItemRenderers.HEAVY_PISTOL, new Item[]{(Item)LTXIItems.HEAVY_PISTOL.get()});
            event.registerFluidType((IClientFluidTypeExtensions)LimaFluidClientExtensions.create(LTXIFluids.VIRIDIC_ACID_TYPE, (boolean)false, null, (LimaColor)LimaColor.WHITE, (LimaColor)LTXIConstants.ACID_GREEN, (float)13.5f), new Holder[]{LTXIFluids.VIRIDIC_ACID_TYPE});
            ResourceLocation gasTexture = LTXIndustries.RESOURCES.location("block/gas");
            IntFunction<LimaFluidClientExtensions> gasExtensions = rgb -> {
                LimaColor color = LimaColor.createOpaque((int)rgb);
                return new LimaFluidClientExtensions(gasTexture, gasTexture, null, null, color.argb32(), LimaFluidClientExtensions.fogTintFromColor((LimaColor)color), 0.0f);
            };
            event.registerFluidType((IClientFluidTypeExtensions)gasExtensions.apply(0xE7E7E7), new Holder[]{LTXIFluids.HYDROGEN_TYPE});
            event.registerFluidType((IClientFluidTypeExtensions)gasExtensions.apply(9545173), new Holder[]{LTXIFluids.OXYGEN_TYPE});
        }

        @SubscribeEvent
        public void registerMenuScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)LTXIMenus.BLOCK_IO_CONFIGURATION.get(), BlockIOConfigurationScreen::new);
            event.register((MenuType)LTXIMenus.MACHINE_UPGRADES.get(), MachineUpgradesScreen::new);
            event.register((MenuType)LTXIMenus.RECIPE_MODE_SELECT.get(), RecipeModeScreen::new);
            event.register((MenuType)LTXIMenus.ENERGY_CELL_ARRAY.get(), EnergyCellArrayScreen::new);
            event.register((MenuType)LTXIMenus.DIGITAL_FURNACE.get(), RecipeLayoutScreen::new);
            event.register((MenuType)LTXIMenus.DIGITAL_SMOKER.get(), RecipeLayoutScreen::new);
            event.register((MenuType)LTXIMenus.DIGITAL_BLAST_FURNACE.get(), RecipeLayoutScreen::new);
            event.register((MenuType)LTXIMenus.GRINDER.get(), RecipeLayoutScreen::new);
            event.register((MenuType)LTXIMenus.MATERIAL_FUSING_CHAMBER.get(), RecipeLayoutScreen::new);
            event.register((MenuType)LTXIMenus.ELECTROCENTRIFUGE.get(), RecipeLayoutScreen::new);
            event.register((MenuType)LTXIMenus.MIXER.get(), RecipeLayoutScreen::new);
            event.register((MenuType)LTXIMenus.VOLTAIC_INJECTOR.get(), RecipeLayoutScreen::new);
            event.register((MenuType)LTXIMenus.CHEM_LAB.get(), RecipeLayoutScreen::new);
            event.register((MenuType)LTXIMenus.ASSEMBLER.get(), RecipeLayoutScreen::new);
            event.register((MenuType)LTXIMenus.FABRICATOR.get(), FabricatorScreen::new);
            event.register((MenuType)LTXIMenus.AUTO_FABRICATOR.get(), AutoFabricatorScreen::new);
            event.register((MenuType)LTXIMenus.EQUIPMENT_UPGRADE_STATION.get(), EquipmentUpgradeStationScreen::new);
            event.register((MenuType)LTXIMenus.MOLECULAR_RECONSTRUCTOR.get(), MolecularReconstructorScreen::new);
            event.register((MenuType)LTXIMenus.DIGITAL_GARDEN.get(), RecipeLayoutScreen::new);
            event.register((MenuType)LTXIMenus.ROCKET_TURRET.get(), TurretScreen::new);
            event.register((MenuType)LTXIMenus.RAILGUN_TURRET.get(), TurretScreen::new);
        }

        @SubscribeEvent
        public void registerParticleProviders(RegisterParticleProvidersEvent event) {
            event.registerSpecial((ParticleType)LTXIParticles.LIGHTFRAG_TRACER.get(), LightfragTracerParticle::createLightfragTracer);
            LimaParticleUtil.registerSprites((RegisterParticleProvidersEvent)event, LTXIParticles.COLOR_GLITTER, AnimatedGlowParticle::colorGlitter);
            event.registerSprite((ParticleType)LTXIParticles.COLOR_FLASH.get(), ColorFlashParticle::new);
            LimaParticleUtil.registerSpritesPosOnly((RegisterParticleProvidersEvent)event, LTXIParticles.COLOR_FULL_SONIC_BOOM, ColorSonicBoomParticle::fullSonicBoom);
            LimaParticleUtil.registerSpritesPosOnly((RegisterParticleProvidersEvent)event, LTXIParticles.COLOR_HALF_SONIC_BOOM, ColorSonicBoomParticle::halfSonicBoom);
            LimaParticleUtil.registerSpecialPosOnly((RegisterParticleProvidersEvent)event, LTXIParticles.HALF_SONIC_BOOM_EMITTER, ColorSonicBoomParticle.EmitterParticle::new);
            LimaParticleUtil.registerSpecialPosOnly((RegisterParticleProvidersEvent)event, LTXIParticles.GROUND_ICICLE, GroundIcicleParticle::new);
            LimaParticleUtil.registerSprites((RegisterParticleProvidersEvent)event, LTXIParticles.CRYO_SNOWFLAKE, AnimatedGlowParticle::cryoSnowflake);
            LimaParticleUtil.registerSprites((RegisterParticleProvidersEvent)event, LTXIParticles.MINI_ELECTRIC_SPARK, AnimatedGlowParticle::electricSpark);
            event.registerSpecial((ParticleType)LTXIParticles.FIXED_ELECTRIC_BOLT.get(), FixedElectricBoltParticle::create);
            event.registerSprite((ParticleType)LTXIParticles.CORROSIVE_DRIP.get(), AcidDripParticle::corrosiveDripParticle);
            event.registerSprite((ParticleType)LTXIParticles.ACID_FALL.get(), AcidDripParticle::createFallParticle);
            event.registerSprite((ParticleType)LTXIParticles.ACID_LAND.get(), AcidDripParticle::createLandParticle);
            LimaParticleUtil.registerSprites((RegisterParticleProvidersEvent)event, LTXIParticles.NEURO_SMOKE, BigColorSmokeParticle::neuroSmokeParticle);
            LimaParticleUtil.registerSpecialPosOnly((RegisterParticleProvidersEvent)event, LTXIParticles.GRENADE_EXPLOSION, GrenadeExplosionParticle::new);
            event.registerSpecial((ParticleType)LTXIParticles.RAILGUN_BOLT.get(), RailgunBoltParticle::create);
        }

        @SubscribeEvent
        public void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)LTXIEntities.GLOWSTICK_PROJECTILE.get(), GlowstickProjectileRenderer::new);
            event.registerEntityRenderer((EntityType)LTXIEntities.ORB_GRENADE.get(), OrbGrenadeRenderer::new);
            event.registerEntityRenderer((EntityType)LTXIEntities.DAYBREAK_ROCKET.get(), RocketRenderer::new);
            event.registerEntityRenderer((EntityType)LTXIEntities.TURRET_ROCKET.get(), RocketRenderer::new);
            event.registerEntityRenderer((EntityType)LTXIEntities.STICKY_FLAME.get(), StickyFlameRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)LTXIBlockEntities.ENERGY_CELL_ARRAY.get(), EnergyCellArrayRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)LTXIBlockEntities.INFINITE_ENERGY_CELL_ARRAY.get(), EnergyCellArrayRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)LTXIBlockEntities.ELECTROCENTRIFUGE.get(), ElectroCentrifugeRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)LTXIBlockEntities.MIXER.get(), MixerRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)LTXIBlockEntities.FABRICATOR.get(), ctx -> new BaseFabricatorRenderer(ctx, -0.1875, 1.0625));
            event.registerBlockEntityRenderer((BlockEntityType)LTXIBlockEntities.AUTO_FABRICATOR.get(), ctx -> new BaseFabricatorRenderer(ctx, 0.0, 0.375));
            event.registerBlockEntityRenderer((BlockEntityType)LTXIBlockEntities.EQUIPMENT_UPGRADE_STATION.get(), EquipmentUpgradeStationRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)LTXIBlockEntities.DIGITAL_GARDEN.get(), DigitalGardenRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)LTXIBlockEntities.ROCKET_TURRET.get(), RocketTurretRenderer::new);
            event.registerBlockEntityRenderer((BlockEntityType)LTXIBlockEntities.RAILGUN_TURRET.get(), RailgunTurretRenderer::new);
        }

        @SubscribeEvent
        public void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(LTXIModelLayers.GLOWSTICK_PROJECTILE, GlowstickProjectileModel::defineLayer);
            event.registerLayerDefinition(LTXIModelLayers.ORB_GRENADE, OrbGrenadeModel::defineLayer);
            event.registerLayerDefinition(LTXIModelLayers.ROCKET, RocketModel::defineLayer);
        }

        @SubscribeEvent
        public void registerBlockColors(RegisterColorHandlersEvent.Block event) {
            BlockColor water = (state, level, pos, tintIndex) -> level != null && pos != null && tintIndex == 1 ? BiomeColors.getAverageWaterColor((BlockAndTintGetter)level, (BlockPos)pos) : -1;
            event.register(water, new Block[]{(Block)LTXIBlocks.DIGITAL_GARDEN.get()});
        }

        @SubscribeEvent
        public void registerGeometryLoaders(ModelEvent.RegisterGeometryLoaders event) {
            EmissiveBiLayerGeometry.BI_LAYER_LOADER.registerLoader(event);
        }

        @SubscribeEvent
        public void registerKeyMappings(RegisterKeyMappingsEvent event) {
            event.register(LTXIKeyMappings.RELOAD_KEY);
        }

        @SubscribeEvent
        public void registerGuiOverlays(RegisterGuiLayersEvent event) {
            BubbleShieldLayer.BUBBLE_SHIELD_LAYER.registerAbove(event, VanillaGuiLayers.PLAYER_HEALTH);
            WeaponHUDInfoLayer.WEAPON_HUD_INFO_LAYER.registerAbove(event, VanillaGuiLayers.HOTBAR);
            WeaponCrosshairLayer.CROSSHAIR_LAYER.registerAbove(event, VanillaGuiLayers.CROSSHAIR);
        }

        @SubscribeEvent
        public void registerTooltipComponentFactories(RegisterClientTooltipComponentFactoriesEvent event) {
            event.register(ItemGridTooltip.class, ClientItemGridTooltip::new);
            event.register(FabricatorIngredientTooltip.class, ClientFabricatorIngredientTooltip::new);
        }

        @SubscribeEvent
        public void registerClientReloadListeners(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)((ResourceManagerReloadListener)LTXIItemRenderers::reloadAll));
            event.registerReloadListener((PreparableReloadListener)BubbleShieldModel.SHIELD_MODEL);
            event.registerReloadListener((PreparableReloadListener)UpgradeIconSprites.getInstance());
        }
    }
}

