/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.gui;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.client.renderer.item.UpgradeModuleItemExtensions;
import liedge.ltxindustries.item.UpgradeModuleItem;
import liedge.ltxindustries.lib.upgrades.UpgradeBaseEntry;
import liedge.ltxindustries.recipe.FabricatingRecipe;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class BlueprintToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = LTXIndustries.RESOURCES.location("blueprint_toast");
    private static final double DISPLAY_TIME = 5000.0;
    private final List<FabricatingRecipe> recipes = new ObjectArrayList();
    private long lastChanged;
    private boolean changed;

    public BlueprintToast(FabricatingRecipe recipe) {
        this.recipes.add(recipe);
    }

    public void addRecipe(FabricatingRecipe recipe) {
        this.recipes.add(recipe);
        this.changed = true;
    }

    public Toast.Visibility render(GuiGraphics graphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        if (this.changed) {
            this.lastChanged = timeSinceLastVisible;
            this.changed = false;
        }
        if (this.recipes.isEmpty()) {
            return Toast.Visibility.HIDE;
        }
        graphics.blitSprite(BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        graphics.drawString(toastComponent.getMinecraft().font, (Component)LTXILangKeys.BLUEPRINT_TOAST_MESSAGE.translate(), 35, 7, LTXIConstants.LIME_GREEN.argb32(), false);
        int size = this.recipes.size();
        int i = (int)((double)timeSinceLastVisible / Math.max(1.0, LimaCoreMath.divideDouble((double)(5000.0 * toastComponent.getNotificationDisplayTimeMultiplier()), (double)size)) % (double)size);
        FabricatingRecipe recipe = this.recipes.get(i);
        ItemStack displayItem = recipe.getFabricatingResultItem();
        Item item = displayItem.getItem();
        if (item instanceof UpgradeModuleItem) {
            UpgradeModuleItem moduleItem = (UpgradeModuleItem)item;
            UpgradeBaseEntry entry = (UpgradeBaseEntry)displayItem.get(moduleItem.entryComponentType());
            if (entry != null) {
                UpgradeModuleItemExtensions.getInstance().renderIconWithRankBar(graphics, entry, 8, 8);
            } else {
                graphics.renderFakeItem(displayItem, 8, 8);
            }
        } else {
            graphics.renderFakeItem(displayItem, 8, 8);
        }
        return (double)(timeSinceLastVisible - this.lastChanged) >= 5000.0 * toastComponent.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
    }
}

