/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.gui;

import java.util.List;
import liedge.ltxindustries.menu.tooltip.GridTooltip;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;

public abstract class ClientGridTooltip<T>
implements ClientTooltipComponent {
    private final List<T> elements;
    private final int maxColumns;
    private final int maxElements;
    private final int width;
    private final int height;

    protected ClientGridTooltip(GridTooltip<T> tooltip) {
        this.elements = tooltip.gridElements();
        this.maxColumns = tooltip.maxColumns();
        this.maxElements = Math.min(this.elements.size(), this.maxColumns * tooltip.maxRows());
        int rows = (int)Math.ceil((double)this.elements.size() / (double)this.maxColumns);
        this.width = Math.min(this.maxColumns, this.elements.size()) * this.elementSize();
        this.height = Math.min(rows, tooltip.maxRows()) * this.elementSize();
    }

    protected abstract int elementSize();

    protected abstract void renderGridElement(T var1, Font var2, int var3, int var4, GuiGraphics var5);

    public int getHeight() {
        return this.height;
    }

    public int getWidth(Font font) {
        return this.width;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        for (int i = 0; i < this.maxElements; ++i) {
            int rx = x + i % this.maxColumns * this.elementSize();
            int ry = y + i / this.maxColumns * this.elementSize();
            this.renderGridElement(this.elements.get(i), font, rx, ry, graphics);
        }
    }
}

