/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import liedge.limacore.client.ItemGuiRenderOverride;
import liedge.ltxindustries.client.gui.UpgradeIconSprites;
import liedge.ltxindustries.lib.upgrades.UpgradeIcon;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public final class UpgradeIconRenderers {
    private static final UpgradeIconRenderers INSTANCE = new UpgradeIconRenderers();
    private final Map<UpgradeIcon.Type, IconRenderer<?>> renderers = new Object2ObjectOpenHashMap();

    public static boolean renderIcon(GuiGraphics graphics, UpgradeIcon icon, int x, int y) {
        return INSTANCE.renderInternal(graphics, x, y, icon);
    }

    public static void renderWithSpriteFallback(GuiGraphics graphics, UpgradeIcon icon, int x, int y) {
        if (!UpgradeIconRenderers.renderIcon(graphics, icon, x, y)) {
            UpgradeIconRenderers.renderSpriteIcon(graphics, UpgradeIcon.DEFAULT_ICON_LOCATION, x, y, 0, 16);
        }
    }

    private UpgradeIconRenderers() {
        this.registerRenderer(UpgradeIcon.Type.NO_RENDER, (graphics, x, y, icon) -> false);
        this.registerRenderer(UpgradeIcon.Type.UPGRADE_SPRITE, (graphics, x, y, icon) -> UpgradeIconRenderers.renderSpriteIcon(graphics, icon.location(), x, y, 150, 16));
        this.registerRenderer(UpgradeIcon.Type.ITEM_STACK, (graphics, x, y, icon) -> UpgradeIconRenderers.renderItemStackIcon(graphics, icon.stack(), x, y));
        this.registerRenderer(UpgradeIcon.Type.COMPOSITE, UpgradeIconRenderers::renderCompositeIcon);
    }

    private <T extends UpgradeIcon> void registerRenderer(UpgradeIcon.Type type, IconRenderer<T> iconRenderer) {
        this.renderers.put(type, iconRenderer);
    }

    private <T extends UpgradeIcon> boolean renderInternal(GuiGraphics graphics, int x, int y, UpgradeIcon uncheckedIcon) {
        IconRenderer<?> renderer = this.renderers.get((Object)uncheckedIcon.getType());
        return renderer.render(graphics, x, y, uncheckedIcon);
    }

    private static boolean renderSpriteIcon(GuiGraphics graphics, ResourceLocation location, int x, int y, int blitOffset, int size) {
        TextureAtlasSprite sprite = UpgradeIconSprites.getInstance().getSprite(location);
        graphics.blit(x, y, blitOffset, size, size, sprite);
        return true;
    }

    private static boolean renderItemStackIcon(GuiGraphics graphics, ItemStack stack, int x, int y) {
        if (stack.getItem() instanceof ItemGuiRenderOverride) {
            return false;
        }
        graphics.renderFakeItem(stack, x, y);
        return true;
    }

    private static boolean renderCompositeIcon(GuiGraphics graphics, int x, int y, UpgradeIcon.CompositeIcon icon) {
        if (!UpgradeIconRenderers.renderIcon(graphics, icon.background(), x, y)) {
            return false;
        }
        int nx = x + icon.xOffset();
        int ny = y + icon.yOffset();
        UpgradeIcon upgradeIcon = icon.overlay();
        Objects.requireNonNull(upgradeIcon);
        UpgradeIcon upgradeIcon2 = upgradeIcon;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UpgradeIcon.SpriteSheetIcon.class, UpgradeIcon.ItemStackIcon.class}, (Object)upgradeIcon2, n)) {
            case 0 -> {
                UpgradeIcon.SpriteSheetIcon sprite = (UpgradeIcon.SpriteSheetIcon)upgradeIcon2;
                yield UpgradeIconRenderers.renderSpriteIcon(graphics, sprite.location(), nx, ny, 200, icon.overlaySize());
            }
            case 1 -> {
                UpgradeIcon.ItemStackIcon item = (UpgradeIcon.ItemStackIcon)upgradeIcon2;
                yield UpgradeIconRenderers.renderSizedItemStack(graphics, item.stack(), nx, ny, icon.overlaySize());
            }
            default -> false;
        };
    }

    private static boolean renderSizedItemStack(GuiGraphics graphics, ItemStack stack, int x, int y, int size) {
        if (stack.getItem() instanceof ItemGuiRenderOverride) {
            return false;
        }
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        poseStack.translate((float)x, (float)y, 50.0f);
        float f = (float)size / 16.0f;
        poseStack.scale(f, f, 1.0f);
        graphics.renderFakeItem(stack, 0, 0);
        poseStack.popPose();
        return true;
    }

    @FunctionalInterface
    private static interface IconRenderer<T extends UpgradeIcon> {
        public boolean render(GuiGraphics var1, int var2, int var3, T var4);
    }
}

