/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.gui.layer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import liedge.limacore.client.gui.LimaGuiLayer;
import liedge.limacore.client.gui.LimaGuiUtil;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.client.renderer.item.WeaponRenderer;
import liedge.ltxindustries.item.weapon.WeaponItem;
import liedge.ltxindustries.lib.weapons.ClientWeaponControls;
import liedge.ltxindustries.util.config.LTXIClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public final class WeaponCrosshairLayer
extends LimaGuiLayer {
    private static final ResourceLocation RELOAD_SPRITE = LTXIndustries.RESOURCES.location("reload_display_outer");
    private static final ResourceLocation RELOAD_SPRITE_INNER = LTXIndustries.RESOURCES.location("reload_display_inner");
    public static final WeaponCrosshairLayer CROSSHAIR_LAYER = new WeaponCrosshairLayer();

    private WeaponCrosshairLayer() {
        super(LTXIndustries.RESOURCES.location("crosshair"));
    }

    protected boolean isVisible(LocalPlayer player) {
        return super.isVisible(player) && Minecraft.getInstance().options.getCameraType().isFirstPerson() && player.getMainHandItem().getItem() instanceof WeaponItem;
    }

    protected void renderGuiLayer(LocalPlayer player, GuiGraphics graphics, float partialTicks) {
        int screenWidth = graphics.guiWidth();
        int screenHeight = graphics.guiHeight();
        ItemStack heldItem = player.getMainHandItem();
        WeaponItem weaponItem = (WeaponItem)heldItem.getItem();
        ClientWeaponControls controls = ClientWeaponControls.of((Player)player);
        if (controls.getReloadTimer().isRunningClient()) {
            int centerX = (screenWidth - 35) / 2;
            int centerY = (screenHeight - 15) / 2;
            graphics.blitSprite(RELOAD_SPRITE, centerX, centerY, 35, 15);
            TextureAtlasSprite innerSprite = Minecraft.getInstance().getGuiSprites().getSprite(RELOAD_SPRITE_INNER);
            LimaGuiUtil.partialHorizontalBlit((GuiGraphics)graphics, (float)(centerX + 17), (float)(centerY + 6), (int)16, (int)3, (float)controls.getReloadTimer().lerpProgressNotPaused(partialTicks), (TextureAtlasSprite)innerSprite);
        } else {
            if (!LTXIClientConfig.SOLID_COLOR_CROSSHAIR.getAsBoolean()) {
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE_MINUS_DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            }
            WeaponRenderer.fromItem(weaponItem).renderCrosshair(player, weaponItem, controls, graphics, partialTicks, screenWidth, screenHeight, LTXIClientConfig.getCrosshairColor());
            RenderSystem.defaultBlendFunc();
        }
    }
}

