/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.gui.layer;

import com.mojang.blaze3d.vertex.PoseStack;
import liedge.limacore.client.LimaComponentUtil;
import liedge.limacore.client.gui.HorizontalAlignment;
import liedge.limacore.client.gui.LimaGuiLayer;
import liedge.limacore.client.gui.VerticalAlignment;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.item.weapon.WeaponItem;
import liedge.ltxindustries.lib.weapons.WeaponReloadSource;
import liedge.ltxindustries.util.config.LTXIClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public final class WeaponHUDInfoLayer
extends LimaGuiLayer {
    private static final ResourceLocation AMMO_DISPLAY_SPRITE = LTXIndustries.RESOURCES.location("ammo_display");
    private static final ResourceLocation ENERGY_AMMO_DISPLAY_SPRITE = LTXIndustries.RESOURCES.location("energy_ammo_display");
    private static final ResourceLocation INFINITE_AMMO_DISPLAY_SPRITE = LTXIndustries.RESOURCES.location("infinite_ammo_display");
    public static final WeaponHUDInfoLayer WEAPON_HUD_INFO_LAYER = new WeaponHUDInfoLayer();

    private WeaponHUDInfoLayer() {
        super(LTXIndustries.RESOURCES.location("weapon_hud"));
    }

    protected boolean isVisible(LocalPlayer player) {
        return super.isVisible(player) && player.getMainHandItem().getItem() instanceof WeaponItem;
    }

    protected void renderGuiLayer(LocalPlayer player, GuiGraphics graphics, float partialTicks) {
        ItemStack heldItem = player.getMainHandItem();
        WeaponItem weaponItem = (WeaponItem)heldItem.getItem();
        WeaponReloadSource reloadSource = weaponItem.getReloadSource(heldItem);
        int ammo = weaponItem.getAmmoLoaded(heldItem);
        int ammoTextColor = ammo > 0 || reloadSource.getType() == WeaponReloadSource.Type.INFINITE ? LTXIConstants.LIME_GREEN.argb32() : 0xFF5555;
        PoseStack poseStack = graphics.pose();
        HorizontalAlignment xAlign = LTXIClientConfig.getWeaponHorizontalAlign();
        int xo = LTXIClientConfig.WEAPON_HUD_X_OFFSET.getAsInt();
        VerticalAlignment yAlign = LTXIClientConfig.getWeaponVerticalAlign();
        int yo = LTXIClientConfig.WEAPON_HUD_Y_OFFSET.getAsInt();
        if (reloadSource.getType() == WeaponReloadSource.Type.ITEM) {
            int x = xAlign.getAbsoluteX(49, graphics.guiWidth(), xo);
            int y = yAlign.getAbsoluteY(13, graphics.guiHeight(), yo);
            graphics.blitSprite(AMMO_DISPLAY_SPRITE, x, y, 49, 13);
            graphics.drawString(Minecraft.getInstance().font, Integer.toString(ammo), x + 5, y + 3, ammoTextColor);
            poseStack.pushPose();
            poseStack.translate((float)(x + 31), (float)y + 4.25f, 0.0f);
            poseStack.scale(0.8f, 0.8f, 1.0f);
            graphics.drawString(Minecraft.getInstance().font, Integer.toString(weaponItem.getAmmoCapacity(heldItem)), 0, 0, 0x9A9A9A, false);
            poseStack.popPose();
        } else if (reloadSource.getType() == WeaponReloadSource.Type.COMMON_ENERGY) {
            int x = xAlign.getAbsoluteX(49, graphics.guiWidth(), xo);
            int y = yAlign.getAbsoluteY(23, graphics.guiHeight(), yo);
            graphics.blitSprite(ENERGY_AMMO_DISPLAY_SPRITE, x, y, 49, 23);
            graphics.drawString(Minecraft.getInstance().font, Integer.toString(ammo), x + 5, y + 3, ammoTextColor);
            poseStack.pushPose();
            poseStack.translate((float)(x + 31), (float)y + 4.25f, 0.0f);
            poseStack.scale(0.8f, 0.8f, 1.0f);
            graphics.drawString(Minecraft.getInstance().font, Integer.toString(weaponItem.getAmmoCapacity(heldItem)), 0, 0, 0x9A9A9A, false);
            int energy = (int)(LimaCoreMath.divideFloat((float)weaponItem.getEnergyStored(heldItem), (float)weaponItem.getEnergyCapacity(heldItem)) * 100.0f);
            String energyText = energy + "%";
            int width = Minecraft.getInstance().font.width(energyText);
            graphics.drawString(Minecraft.getInstance().font, energyText, -4 + (24 - width) / 2, 12, LTXIConstants.REM_BLUE.argb32(), false);
            poseStack.popPose();
        } else {
            int x = xAlign.getAbsoluteX(47, graphics.guiWidth(), xo);
            int y = yAlign.getAbsoluteY(13, graphics.guiHeight(), yo);
            graphics.blitSprite(INFINITE_AMMO_DISPLAY_SPRITE, x, y, 47, 13);
            graphics.drawString(Minecraft.getInstance().font, Integer.toString(ammo), x + 5, y + 3, ammoTextColor);
            poseStack.pushPose();
            poseStack.translate((float)(x + 32), (float)(y + 1), 0.0f);
            poseStack.scale(1.5f, 1.5f, 1.0f);
            graphics.drawString(Minecraft.getInstance().font, LimaComponentUtil.INFINITY_SYMBOL, 0, 0, LTXIConstants.CREATIVE_PINK.argb32(), false);
            poseStack.popPose();
        }
    }
}

