/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.gui.screen;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import liedge.limacore.blockentity.IOAccess;
import liedge.limacore.blockentity.RelativeHorizontalSide;
import liedge.limacore.client.LimaComponentUtil;
import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.limacore.lib.Translatable;
import liedge.limacore.registry.game.LimaCoreNetworkSerializers;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.blockentity.base.BlockIOConfiguration;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.client.gui.screen.LTXIScreen;
import liedge.ltxindustries.client.gui.widget.LimaRenderableButton;
import liedge.ltxindustries.client.gui.widget.LimaSidebarButton;
import liedge.ltxindustries.client.gui.widget.SubMenuBackButton;
import liedge.ltxindustries.menu.BlockIOConfigurationMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class BlockIOConfigurationScreen
extends LTXIScreen<BlockIOConfigurationMenu> {
    private static final ResourceLocation BUTTON_GRID_TEXTURE = LTXIndustries.RESOURCES.textureLocation("gui", "io_button_grid");
    private static final ResourceLocation INPUT_SPRITE = LTXIndustries.RESOURCES.location("widget/io_selector_input");
    private static final ResourceLocation OUTPUT_SPRITE = LTXIndustries.RESOURCES.location("widget/io_selector_output");
    private static final ResourceLocation BOTH_SPRITE = LTXIndustries.RESOURCES.location("widget/io_selector_both");
    private static final ResourceLocation DISABLED_SPRITE = LTXIndustries.RESOURCES.location("widget/io_selector_disabled");
    private static final ResourceLocation AUTO_OUT_DISABLED_SPRITE = LTXIndustries.RESOURCES.location("widget/auto_output_disabled");
    private static final ResourceLocation AUTO_OUT_ENABLED_SPRITE = LTXIndustries.RESOURCES.location("widget/auto_output_enabled");
    private static final ResourceLocation AUTO_IN_DISABLED_SPRITE = LTXIndustries.RESOURCES.location("widget/auto_input_disabled");
    private static final ResourceLocation AUTO_IN_ENABLED_SPRITE = LTXIndustries.RESOURCES.location("widget/auto_input_enabled");

    public BlockIOConfigurationScreen(BlockIOConfigurationMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title, 176, 166);
        this.inventoryLabelY = 73;
        this.leftPadding = 18;
        this.rightPadding = 18;
    }

    private BlockIOConfiguration getIOConfiguration() {
        return ((BlockIOConfigurationMenu)this.menu).getIOConfiguration();
    }

    protected void addWidgets() {
        this.addRenderableWidget((GuiEventListener)new SubMenuBackButton(this.leftPos - this.leftPadding, this.topPos + 3, this, 0));
        for (RelativeHorizontalSide side : ((BlockIOConfigurationMenu)this.menu).getIOConfigRules().validSides()) {
            IOButton button = switch (side) {
                default -> throw new MatchException(null, null);
                case RelativeHorizontalSide.TOP -> new IOButton(this.leftPos + 76, this.topPos + 21, side);
                case RelativeHorizontalSide.BOTTOM -> new IOButton(this.leftPos + 76, this.topPos + 53, side);
                case RelativeHorizontalSide.FRONT -> new IOButton(this.leftPos + 76, this.topPos + 37, side);
                case RelativeHorizontalSide.REAR -> new IOButton(this.leftPos + 92, this.topPos + 53, side);
                case RelativeHorizontalSide.LEFT -> new IOButton(this.leftPos + 60, this.topPos + 37, side);
                case RelativeHorizontalSide.RIGHT -> new IOButton(this.leftPos + 92, this.topPos + 37, side);
            };
            this.addRenderableWidget((GuiEventListener)button);
        }
        int rightSidebarY = this.topPos + 3;
        if (((BlockIOConfigurationMenu)this.menu).getIOConfigRules().allowsAutoInput()) {
            this.addRenderableWidget((GuiEventListener)new AutoIOButton(this.rightPos, rightSidebarY, 3, LTXILangKeys.AUTO_INPUT_OFF_TOOLTIP, LTXILangKeys.AUTO_INPUT_ON_TOOLTIP, AUTO_IN_DISABLED_SPRITE, AUTO_IN_ENABLED_SPRITE, () -> this.getIOConfiguration().autoInput()));
            rightSidebarY += 20;
        }
        if (((BlockIOConfigurationMenu)this.menu).getIOConfigRules().allowsAutoOutput()) {
            this.addRenderableWidget((GuiEventListener)new AutoIOButton(this.rightPos, rightSidebarY, 4, LTXILangKeys.AUTO_OUTPUT_OFF_TOOLTIP, LTXILangKeys.AUTO_OUTPUT_ON_TOOLTIP, AUTO_OUT_DISABLED_SPRITE, AUTO_OUT_ENABLED_SPRITE, () -> this.getIOConfiguration().autoOutput()));
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        this.blitInventoryAndHotbar(guiGraphics, 7, 83);
        guiGraphics.blit(BUTTON_GRID_TEXTURE, this.leftPos + 60, this.topPos + 21, 0.0f, 0.0f, 48, 48, 48, 48);
    }

    private class IOButton
    extends LimaRenderableButton {
        private final RelativeHorizontalSide side;

        public IOButton(int x, int y, RelativeHorizontalSide side) {
            super(x, y, 16, 16);
            this.side = side;
        }

        @Override
        public void onPress(int button) {
            if (button == 0) {
                BlockIOConfigurationScreen.this.sendCustomButtonData(1, this.side, (Supplier)LimaCoreNetworkSerializers.RELATIVE_SIDE);
            } else {
                BlockIOConfigurationScreen.this.sendCustomButtonData(2, this.side, (Supplier)LimaCoreNetworkSerializers.RELATIVE_SIDE);
            }
        }

        @Override
        protected ResourceLocation unfocusedSprite() {
            return switch (BlockIOConfigurationScreen.this.getIOConfiguration().getIOAccess(this.side)) {
                default -> throw new MatchException(null, null);
                case IOAccess.DISABLED -> DISABLED_SPRITE;
                case IOAccess.INPUT_ONLY -> INPUT_SPRITE;
                case IOAccess.OUTPUT_ONLY -> OUTPUT_SPRITE;
                case IOAccess.INPUT_AND_OUTPUT -> BOTH_SPRITE;
            };
        }

        public boolean hasTooltip() {
            return true;
        }

        public void createWidgetTooltip(TooltipLineConsumer consumer) {
            MutableComponent sideTooltip = this.side.translate().withStyle(LTXIConstants.LIME_GREEN.chatStyle()).append(CommonComponents.SPACE).append((Component)ComponentUtils.wrapInSquareBrackets((Component)LimaComponentUtil.localizeDirection((Direction)this.side.resolveAbsoluteSide(((BlockIOConfigurationMenu.MenuContext)((BlockIOConfigurationMenu)BlockIOConfigurationScreen.this.menu).menuContext()).blockEntity().getFacing())).translate()));
            consumer.accept((FormattedText)sideTooltip);
            consumer.accept((FormattedText)BlockIOConfigurationScreen.this.getIOConfiguration().getIOAccess(this.side).translate());
        }

        protected boolean isValidClickButton(int button) {
            return button == 0 || button == 1;
        }

        @Override
        protected boolean acceptsKeyboardInput() {
            return false;
        }
    }

    private class AutoIOButton
    extends LimaSidebarButton.RightSided {
        private final int buttonId;
        private final Component offLabel;
        private final Component onLabel;
        private final ResourceLocation offSprite;
        private final ResourceLocation onSprite;
        private final BooleanSupplier stateGetter;

        protected AutoIOButton(int x, int y, int buttonId, Translatable offLabel, Translatable onLabel, ResourceLocation offSprite, ResourceLocation onSprite, BooleanSupplier stateGetter) {
            super(x, y, (Component)Component.empty());
            this.buttonId = buttonId;
            this.offLabel = offLabel.translate();
            this.onLabel = onLabel.translate();
            this.offSprite = offSprite;
            this.onSprite = onSprite;
            this.stateGetter = stateGetter;
        }

        @Override
        public void onPress(int button) {
            BlockIOConfigurationScreen.this.sendUnitButtonData(this.buttonId);
        }

        public boolean hasTooltip() {
            return true;
        }

        public void createWidgetTooltip(TooltipLineConsumer consumer) {
            Component label = this.stateGetter.getAsBoolean() ? this.onLabel : this.offLabel;
            consumer.accept((FormattedText)label);
        }

        @Override
        protected void renderContents(GuiGraphics graphics, int guiX, int guiY) {
            ResourceLocation sprite = this.stateGetter.getAsBoolean() ? this.onSprite : this.offSprite;
            this.renderSprite(graphics, sprite, guiX, guiY);
        }
    }
}

