/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.gui.screen;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import liedge.limacore.capability.energy.LimaEnergyUtil;
import liedge.limacore.registry.game.LimaCoreNetworkSerializers;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.blockentity.BaseFabricatorBlockEntity;
import liedge.ltxindustries.client.LTXIClientRecipes;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.client.gui.screen.LTXIMachineScreen;
import liedge.ltxindustries.client.gui.screen.LTXIScreen;
import liedge.ltxindustries.client.gui.widget.BaseScrollGridRenderable;
import liedge.ltxindustries.client.gui.widget.FabricatorProgressWidget;
import liedge.ltxindustries.client.gui.widget.ScrollbarWidget;
import liedge.ltxindustries.menu.FabricatorMenu;
import liedge.ltxindustries.menu.layout.LayoutSlot;
import liedge.ltxindustries.recipe.FabricatingRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FabricatorScreen
extends LTXIMachineScreen<FabricatorMenu> {
    private static final ResourceLocation BLUEPRINT_SLOT_SPRITE = LTXIndustries.RESOURCES.location("slot/blank_blueprint");
    private final List<RecipeHolder<FabricatingRecipe>> recipes;
    @Nullable
    private SelectorGrid selectorGrid;
    @Nullable
    private ScrollbarWidget scrollbar;

    public FabricatorScreen(FabricatorMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title, 190, 200);
        this.recipes = LTXIClientRecipes.getUnlockedFabricatingRecipes((LocalPlayer)inventory.player);
        this.inventoryLabelX = 14;
        this.inventoryLabelY = 107;
    }

    @Override
    protected void addWidgets() {
        super.addWidgets();
        this.addRenderableOnly((Renderable)new FabricatorProgressWidget(this.leftPos + 61, this.topPos + 83, (BaseFabricatorBlockEntity)((FabricatorMenu)this.menu).menuContext()));
        this.selectorGrid = (SelectorGrid)this.addRenderableOnly((Renderable)new SelectorGrid(this.leftPos + 76, this.topPos + 32, this));
        this.scrollbar = (ScrollbarWidget)this.addRenderableWidget(new ScrollbarWidget(this.leftPos + 168, this.topPos + 32, 72, this.selectorGrid));
        this.scrollbar.reset();
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTick, mouseX, mouseY);
        this.blitInventoryAndHotbar(graphics, 14, 117);
        this.blitPowerInSlot(graphics, 7, 52);
        this.blitSlotSprite(graphics, BLUEPRINT_SLOT_SPRITE, 42, 60);
        this.blitOutputSlot(graphics, 39, 83);
        this.blitDarkPanel(graphics, 75, 31, 92, 74);
        this.blitLightPanel(graphics, 167, 31, 10, 74);
    }

    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        if (((FabricatorMenu)this.menu).getCarried().isEmpty() && this.selectorGrid != null && this.selectorGrid.renderTooltips(graphics, x, y)) {
            return;
        }
        super.renderTooltip(graphics, x, y);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.selectorGrid != null && this.scrollbar != null && this.selectorGrid.isMouseOver(mouseX, mouseY) && this.scrollbar.moveScrollBar(scrollY)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (((FabricatorMenu)this.menu).getCarried().isEmpty() && (mouseButton == 0 || mouseButton == 1) && this.selectorGrid != null && this.selectorGrid.onGridClicked(mouseX, mouseY, mouseButton)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    private static class SelectorGrid
    extends BaseScrollGridRenderable.FixedElements<RecipeHolder<FabricatingRecipe>> {
        private final FabricatorScreen parent;
        private final BaseFabricatorBlockEntity blockEntity;
        private int selectedRecipe = -1;

        SelectorGrid(int x, int y, FabricatorScreen parent) {
            super(x, y, 18, 18, 5, 4, parent.recipes);
            this.parent = parent;
            this.blockEntity = (BaseFabricatorBlockEntity)((FabricatorMenu)parent.menu).menuContext();
        }

        @Override
        protected void onScrollRowChanged(int newScrollRow) {
            super.onScrollRowChanged(newScrollRow);
            this.selectedRecipe = -1;
        }

        @Override
        public void renderElement(GuiGraphics graphics, RecipeHolder<FabricatingRecipe> element, int posX, int posY, int gridIndex, int elementIndex, int mouseX, int mouseY) {
            FabricatingRecipe recipe = (FabricatingRecipe)element.value();
            ResourceLocation sprite = this.blockEntity.isCrafting() && this.blockEntity.getRecipeCheck().getLastUsedRecipe((Level)Minecraft.getInstance().level).map(r -> r.value() == recipe).orElse(false) != false ? LTXIScreen.GRID_UNIT_SELECTED : (gridIndex == this.selectedRecipe ? LayoutSlot.ITEM_SLOT_SPRITE : (this.isMouseOverElement(mouseX, mouseY, posX, posY) ? LTXIScreen.GRID_UNIT_FOCUSED : LTXIScreen.GRID_UNIT));
            graphics.blitSprite(sprite, posX, posY, 18, 18);
            ItemStack resultStack = recipe.getFabricatingResultItem();
            graphics.renderFakeItem(resultStack, posX + 1, posY + 1);
            graphics.renderItemDecorations(Minecraft.getInstance().font, resultStack, posX + 1, posY + 1);
        }

        @Override
        public void renderElementTooltip(GuiGraphics graphics, RecipeHolder<FabricatingRecipe> element, int mouseX, int mouseY, int gridIndex, int elementIndex) {
            FabricatingRecipe recipe = (FabricatingRecipe)element.value();
            List lines = Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)recipe.getFabricatingResultItem());
            if (gridIndex == this.selectedRecipe) {
                lines.add(LTXILangKeys.FABRICATOR_SELECTED_RECIPE_TOOLTIP.translate().withStyle(LTXIConstants.LIME_GREEN.chatStyle()));
            }
            lines.add(LTXILangKeys.INLINE_ENERGY_REQUIRED_TOOLTIP.translateArgs(new Object[]{LimaEnergyUtil.toEnergyString((int)recipe.getEnergyRequired())}).withStyle(LTXIConstants.REM_BLUE.chatStyle()));
            graphics.renderTooltip(Minecraft.getInstance().font, lines, Optional.of(recipe.createIngredientTooltip()), mouseX, mouseY);
        }

        @Override
        public void onElementClicked(RecipeHolder<FabricatingRecipe> element, double mouseX, double mouseY, int button, int gridIndex, int elementIndex) {
            if (button == 0) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                if (this.selectedRecipe != gridIndex) {
                    this.selectedRecipe = gridIndex;
                } else {
                    this.parent.sendCustomButtonData(2, element.id(), (Supplier)LimaCoreNetworkSerializers.RESOURCE_LOCATION);
                }
            } else if (this.selectedRecipe == gridIndex) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                this.parent.sendCustomButtonData(3, element.id(), (Supplier)LimaCoreNetworkSerializers.RESOURCE_LOCATION);
            }
        }
    }
}

