/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.gui.screen;

import java.util.Iterator;
import liedge.limacore.capability.energy.EnergyHolderBlockEntity;
import liedge.limacore.client.gui.LimaRenderable;
import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.blockentity.base.BlockEntityInputType;
import liedge.ltxindustries.blockentity.base.UpgradesHolderBlockEntity;
import liedge.ltxindustries.blockentity.template.LTXIMachineBlockEntity;
import liedge.ltxindustries.client.gui.screen.LTXIScreen;
import liedge.ltxindustries.client.gui.widget.EnergyGaugeWidget;
import liedge.ltxindustries.client.gui.widget.MachineUpgradesButton;
import liedge.ltxindustries.client.gui.widget.OpenIOControlButton;
import liedge.ltxindustries.menu.LTXIMachineMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public abstract class LTXIMachineScreen<M extends LTXIMachineMenu<?>>
extends LTXIScreen<M> {
    private static final ResourceLocation STATS_WIDGET_SPRITE = LTXIndustries.RESOURCES.location("widget/machine_stats");

    protected LTXIMachineScreen(M menu, Inventory inventory, Component title, int primaryWidth, int primaryHeight) {
        super(menu, inventory, title, primaryWidth, primaryHeight);
        this.rightPadding = 18;
        if (((LTXIMachineBlockEntity)menu.menuContext()).hasStatsTooltips()) {
            this.leftPadding = 18;
        }
        this.inventoryLabelY = 73;
    }

    protected void addWidgets() {
        Iterator<BlockEntityInputType> iterator = ((LTXIMachineMenu)this.menu).menuContext();
        if (iterator instanceof EnergyHolderBlockEntity) {
            EnergyHolderBlockEntity energyMachine = (EnergyHolderBlockEntity)iterator;
            this.addRenderableOnly((Renderable)new EnergyGaugeWidget(energyMachine, this.leftPos + 10, this.topPos + 9));
        }
        this.addRenderableWidget((GuiEventListener)new MachineUpgradesButton(this.rightPos, this.topPos + 3, this));
        if (((LTXIMachineBlockEntity)((LTXIMachineMenu)this.menu).menuContext()).hasStatsTooltips()) {
            this.addRenderableOnly((Renderable)new StatsWidget(this.leftPos - this.leftPadding, this.bottomPos - 23, (UpgradesHolderBlockEntity)((LTXIMachineMenu)this.menu).menuContext()));
        }
        int sidebarY = 23;
        for (BlockEntityInputType type : ((LTXIMachineBlockEntity)((LTXIMachineMenu)this.menu).menuContext()).getConfigurableInputTypes()) {
            this.addRenderableWidget((GuiEventListener)new OpenIOControlButton(this.rightPos, this.topPos + sidebarY, this, 1, type));
            sidebarY += 20;
        }
    }

    private record StatsWidget(int x, int y, UpgradesHolderBlockEntity blockEntity) implements LimaRenderable
    {
        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return 18;
        }

        public int getHeight() {
            return 20;
        }

        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.blitSprite(STATS_WIDGET_SPRITE, this.x, this.y, this.getWidth(), this.getHeight());
        }

        public boolean hasTooltip() {
            return true;
        }

        public void createWidgetTooltip(TooltipLineConsumer consumer) {
            this.blockEntity.appendStatsTooltips(consumer);
        }
    }
}

