/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.gui.screen;

import liedge.limacore.client.gui.LimaGuiUtil;
import liedge.limacore.client.gui.LimaMenuScreen;
import liedge.limacore.menu.LimaMenu;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.menu.layout.LayoutSlot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public abstract class LTXIScreen<M extends LimaMenu<?>>
extends LimaMenuScreen<M> {
    private static final ResourceLocation CONTAINER_BASE_TEXTURE = LTXIndustries.RESOURCES.textureLocation("gui", "container_base");
    private static final ResourceLocation SLOT_TILE_TEXTURE = LTXIndustries.RESOURCES.textureLocation("gui", "slots");
    private static final ResourceLocation LIGHT_PANEL_TEXTURE = LTXIndustries.RESOURCES.textureLocation("gui", "light_panel");
    private static final ResourceLocation DARK_PANEL_TEXTURE = LTXIndustries.RESOURCES.textureLocation("gui", "dark_panel");
    private static final ResourceLocation POWER_IN_SLOT = LTXIndustries.RESOURCES.location("slot/power_in");
    protected static final ResourceLocation POWER_OUT_SLOT = LTXIndustries.RESOURCES.location("slot/power_out");
    private static final ResourceLocation BIG_OUTPUT_SLOT = LTXIndustries.RESOURCES.location("slot/big_output");
    static final ResourceLocation GRID_UNIT = LTXIndustries.RESOURCES.location("widget/grid_unit");
    static final ResourceLocation GRID_UNIT_FOCUSED = LTXIndustries.RESOURCES.location("widget/grid_unit_focus");
    static final ResourceLocation GRID_UNIT_SELECTED = LTXIndustries.RESOURCES.location("widget/grid_unit_selected");
    private static final int BG_CORNER_SIZE = 4;
    private static final int TITLE_BAR_HEIGHT = 15;
    private int titleBarWidth;
    private int titleBarX;

    protected LTXIScreen(M menu, Inventory inventory, Component title, int primaryWidth, int primaryHeight) {
        super(menu, inventory, title, primaryWidth, primaryHeight, LTXIConstants.LIME_GREEN.argb32());
        this.topPadding = 15;
        this.titleLabelY = -9;
    }

    protected void positionLabels() {
        super.positionLabels();
        this.titleBarWidth = Math.min(this.primaryWidth - 8, this.font.width((FormattedText)this.title) + 18);
        this.titleBarX = (this.primaryWidth - this.titleBarWidth) / 2;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.nineSliceBlit(guiGraphics, CONTAINER_BASE_TEXTURE, 4, 0, 0, this.primaryWidth, this.primaryHeight, 16, 16);
        LimaGuiUtil.nineSliceNoBottomBlit((GuiGraphics)guiGraphics, (ResourceLocation)CONTAINER_BASE_TEXTURE, (int)4, (int)(this.leftPos + this.titleBarX), (int)(this.topPos - this.topPadding), (int)this.titleBarWidth, (int)15, (int)16, (int)16);
    }

    protected void blitSlotGrid(GuiGraphics graphics, int x, int y, int width, int height) {
        LTXIScreen.blitEmptySlotGrid(graphics, this.leftPos + x, this.topPos + y, width, height);
    }

    protected void blitInventoryAndHotbar(GuiGraphics graphics, int x, int y) {
        this.blitSlotGrid(graphics, x, y, 9, 3);
        this.blitSlotGrid(graphics, x, y + 58, 9, 1);
    }

    protected void blitSprite(GuiGraphics graphics, ResourceLocation spriteLocation, int x, int y, int width, int height) {
        graphics.blitSprite(spriteLocation, this.leftPos + x, this.topPos + y, width, height);
    }

    protected void blitSlotSprite(GuiGraphics graphics, ResourceLocation slotSprite, int x, int y) {
        this.blitSprite(graphics, slotSprite, x, y, 18, 18);
    }

    protected void blitEmptySlot(GuiGraphics graphics, int x, int y) {
        this.blitSlotSprite(graphics, LayoutSlot.ITEM_SLOT_SPRITE, x, y);
    }

    protected void blitPowerInSlot(GuiGraphics graphics, int x, int y) {
        this.blitSlotSprite(graphics, POWER_IN_SLOT, x, y);
    }

    protected void blitOutputSlot(GuiGraphics graphics, int x, int y) {
        LTXIScreen.blitOutputSlotSprite(graphics, this.leftPos + x, this.topPos + y);
    }

    protected void blitLightPanel(GuiGraphics graphics, int x, int y, int width, int height) {
        this.nineSliceBlit(graphics, LIGHT_PANEL_TEXTURE, 1, x, y, width, height, 18, 18);
    }

    protected void blitDarkPanel(GuiGraphics graphics, int x, int y, int width, int height) {
        this.nineSliceBlit(graphics, DARK_PANEL_TEXTURE, 1, x, y, width, height, 18, 18);
    }

    protected void nineSliceBlit(GuiGraphics graphics, ResourceLocation textureLocation, int cornerSize, int x, int y, int width, int height, int textureWidth, int textureHeight) {
        LimaGuiUtil.nineSliceBlit((GuiGraphics)graphics, (ResourceLocation)textureLocation, (int)cornerSize, (int)(this.leftPos + x), (int)(this.topPos + y), (int)width, (int)height, (int)textureWidth, (int)textureHeight);
    }

    public static void blitOutputSlotSprite(GuiGraphics graphics, int x, int y) {
        graphics.blitSprite(BIG_OUTPUT_SLOT, x, y, 22, 22);
    }

    public static void blitEmptySlotGrid(GuiGraphics graphics, int x, int y, int width, int height) {
        graphics.blit(SLOT_TILE_TEXTURE, x, y, 0, 0, width * 18, height * 18);
    }
}

