/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.gui.screen;

import java.util.List;
import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.blockentity.base.RecipeModeHolderBlockEntity;
import liedge.ltxindustries.blockentity.base.VariableTimedProcessBlockEntity;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.client.gui.screen.LTXIMachineScreen;
import liedge.ltxindustries.client.gui.widget.LimaSidebarButton;
import liedge.ltxindustries.client.gui.widget.MachineProgressWidget;
import liedge.ltxindustries.menu.RecipeLayoutMenu;
import liedge.ltxindustries.menu.layout.LayoutSlot;
import liedge.ltxindustries.menu.layout.RecipeLayout;
import liedge.ltxindustries.recipe.RecipeMode;
import liedge.ltxindustries.registry.LTXIRegistries;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;

public final class RecipeLayoutScreen
extends LTXIMachineScreen<RecipeLayoutMenu<?>> {
    public static final ResourceLocation MODE_OVERLAY_SPRITE = LTXIndustries.RESOURCES.location("widget/recipe_modes");
    private final RecipeLayout layout;
    @Nullable
    private final RecipeModeHolderBlockEntity modeHolder;

    public RecipeLayoutScreen(RecipeLayoutMenu<?> menu, Inventory inventory, Component title) {
        super(menu, inventory, title, 176, 166);
        this.layout = menu.getLayout();
        Object object = menu.menuContext();
        if (object instanceof RecipeModeHolderBlockEntity) {
            RecipeModeHolderBlockEntity blockEntity = (RecipeModeHolderBlockEntity)object;
            Holder<RecipeType<?>> holder = blockEntity.getRecipeTypeHolder();
            boolean check = inventory.player.level().registryAccess().registry(LTXIRegistries.Keys.RECIPE_MODES).stream().flatMap(Registry::holders).anyMatch(o -> ((RecipeMode)o.value()).recipeTypes().contains(holder));
            this.modeHolder = check ? blockEntity : null;
        } else {
            this.modeHolder = null;
        }
    }

    @Override
    protected void addWidgets() {
        super.addWidgets();
        this.addRenderableOnly((Renderable)new MachineProgressWidget((VariableTimedProcessBlockEntity)((RecipeLayoutMenu)this.menu).menuContext(), this.leftPos + this.layout.progressBarX(), this.topPos + this.layout.progressBarY()));
        if (this.modeHolder != null) {
            this.addRenderableWidget((GuiEventListener)new RecipeModeButton(this.leftPos - this.leftPadding, this.bottomPos - 43, this, this.modeHolder));
        }
    }

    @Override
    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTick, mouseX, mouseY);
        this.blitInventoryAndHotbar(guiGraphics, 7, 83);
        this.blitPowerInSlot(guiGraphics, 7, 52);
        RecipeLayoutScreen.renderLayout(guiGraphics, this.leftPos, this.topPos, this.layout);
    }

    public static void renderLayout(GuiGraphics graphics, int screenX, int screenY, RecipeLayout layout) {
        for (LayoutSlot.Type slotType : LayoutSlot.Type.values()) {
            if (slotType.getContentsType() == null) continue;
            List<LayoutSlot> layoutSlots = layout.getSlotsForType(slotType);
            for (LayoutSlot slot : layoutSlots) {
                int sx = screenX + slot.x() - 1;
                int sy = screenY + slot.y() - 1;
                graphics.blitSprite(slot.type().getSprite(), sx, sy, 18, 18);
            }
        }
    }

    private static class RecipeModeButton
    extends LimaSidebarButton.LeftSided {
        private final RecipeLayoutScreen parent;
        private final RecipeModeHolderBlockEntity blockEntity;

        public RecipeModeButton(int x, int y, RecipeLayoutScreen parent, RecipeModeHolderBlockEntity blockEntity) {
            super(x, y, (Component)Component.empty());
            this.parent = parent;
            this.blockEntity = blockEntity;
        }

        @Override
        protected void renderContents(GuiGraphics graphics, int guiX, int guiY) {
            Holder<RecipeMode> mode = this.blockEntity.getMode();
            if (mode == null) {
                this.renderSprite(graphics, MODE_OVERLAY_SPRITE, guiX, guiY);
            } else {
                graphics.renderFakeItem(((RecipeMode)mode.value()).displayItem(), guiX, guiY);
            }
        }

        @Override
        public void onPress(int button) {
            this.parent.sendUnitButtonData(2);
        }

        public boolean hasTooltip() {
            return true;
        }

        public void createWidgetTooltip(TooltipLineConsumer consumer) {
            consumer.accept((FormattedText)LTXILangKeys.RECIPE_MODES_TITLE_OR_TOOLTIP.translate());
            Holder<RecipeMode> mode = this.blockEntity.getMode();
            Component modeComponent = mode != null ? ((RecipeMode)mode.value()).displayName() : LTXILangKeys.NONE_UNIVERSAL_TOOLTIP.translate().withStyle(ChatFormatting.GRAY);
            consumer.accept((FormattedText)LTXILangKeys.RECIPE_MODE_CURRENT_MODE.translateArgs(new Object[]{modeComponent}));
        }
    }
}

