/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.gui.screen;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import liedge.limacore.client.gui.LimaGuiUtil;
import liedge.ltxindustries.blockentity.base.RecipeModeHolderBlockEntity;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.client.gui.screen.LTXIScreen;
import liedge.ltxindustries.client.gui.widget.BaseGridRenderable;
import liedge.ltxindustries.client.gui.widget.SubMenuBackButton;
import liedge.ltxindustries.menu.RecipeModeMenu;
import liedge.ltxindustries.recipe.RecipeMode;
import liedge.ltxindustries.registry.LTXIRegistries;
import liedge.ltxindustries.registry.game.LTXINetworkSerializers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;

public class RecipeModeScreen
extends LTXIScreen<RecipeModeMenu> {
    private final List<SelectorOption> options;
    private SelectorGrid selectorGrid;

    public RecipeModeScreen(RecipeModeMenu menu, Inventory inventory, Component title) {
        super(menu, inventory, title, 176, 166);
        this.leftPadding = 18;
        this.options = new ObjectArrayList();
        this.options.add(new SelectorOption(Items.BARRIER.getDefaultInstance(), null));
        Holder<RecipeType<?>> holder = ((RecipeModeHolderBlockEntity)menu.menuContext()).getRecipeTypeHolder();
        inventory.player.level().registryAccess().registry(LTXIRegistries.Keys.RECIPE_MODES).stream().flatMap(Registry::holders).filter(o -> ((RecipeMode)o.value()).recipeTypes().contains(holder)).limit(23L).map(o -> new SelectorOption(((RecipeMode)o.value()).displayItem(), (Holder<RecipeMode>)o)).forEach(this.options::add);
    }

    protected void addWidgets() {
        this.addRenderableWidget((GuiEventListener)new SubMenuBackButton(this.leftPos - this.leftPadding, this.topPos + 3, this, 0));
        this.selectorGrid = (SelectorGrid)this.addRenderableOnly((Renderable)new SelectorGrid(this.leftPos + 15, this.topPos + 12, this));
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTick, mouseX, mouseY);
        this.blitInventoryAndHotbar(graphics, 7, 83);
        this.blitDarkPanel(graphics, 14, 11, 146, 56);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (((RecipeModeMenu)this.menu).getCarried().isEmpty() && button == 0 && this.selectorGrid != null && this.selectorGrid.onGridClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        if (((RecipeModeMenu)this.menu).getCarried().isEmpty() && this.selectorGrid != null) {
            this.selectorGrid.renderTooltips(graphics, x, y);
        }
        super.renderTooltip(graphics, x, y);
    }

    private record SelectorOption(ItemStack stack, @Nullable Holder<RecipeMode> mode) {
    }

    private static class SelectorGrid
    extends BaseGridRenderable.FixedElements<SelectorOption> {
        private final RecipeModeScreen parent;
        private final RecipeModeHolderBlockEntity blockEntity;

        SelectorGrid(int x, int y, RecipeModeScreen parent) {
            super(x, y, 18, 18, 8, 3, parent.options);
            this.parent = parent;
            this.blockEntity = (RecipeModeHolderBlockEntity)((RecipeModeMenu)parent.menu).menuContext();
        }

        @Override
        public void renderElement(GuiGraphics graphics, SelectorOption element, int posX, int posY, int gridIndex, int elementIndex, int mouseX, int mouseY) {
            ResourceLocation sprite = this.blockEntity.getMode() == element.mode ? LTXIScreen.GRID_UNIT_SELECTED : (LimaGuiUtil.isMouseWithinArea((double)mouseX, (double)mouseY, (int)posX, (int)posY, (int)18, (int)18) ? LTXIScreen.GRID_UNIT_FOCUSED : LTXIScreen.GRID_UNIT);
            graphics.blitSprite(sprite, posX, posY, 18, 18);
            graphics.renderFakeItem(element.stack, posX + 1, posY + 1);
        }

        @Override
        public void renderElementTooltip(GuiGraphics graphics, SelectorOption element, int mouseX, int mouseY, int gridIndex, int elementIndex) {
            Holder<RecipeMode> mode = element.mode;
            MutableComponent tooltip = mode != null ? ((RecipeMode)mode.value()).displayName() : LTXILangKeys.NONE_UNIVERSAL_TOOLTIP.translate();
            graphics.renderTooltip(Minecraft.getInstance().font, (Component)tooltip, mouseX, mouseY);
        }

        @Override
        public void onElementClicked(SelectorOption element, double mouseX, double mouseY, int button, int gridIndex, int elementIndex) {
            if (this.blockEntity.getMode() != element.mode) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                this.parent.sendCustomButtonData(1, Optional.ofNullable(element.mode), (Supplier)LTXINetworkSerializers.RECIPE_MODE);
            }
        }
    }
}

