/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.limacore.registry.game.LimaCoreNetworkSerializers;
import liedge.limacore.util.LimaRegistryUtil;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.client.gui.UpgradeIconRenderers;
import liedge.ltxindustries.client.gui.screen.LTXIScreen;
import liedge.ltxindustries.client.gui.widget.BaseScrollGridRenderable;
import liedge.ltxindustries.client.gui.widget.ScrollbarWidget;
import liedge.ltxindustries.lib.upgrades.UpgradeBase;
import liedge.ltxindustries.menu.UpgradesConfigMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public abstract class UpgradesConfigScreen<U extends UpgradeBase<?, U>, M extends UpgradesConfigMenu<?, U, ?>>
extends LTXIScreen<M> {
    private static final ResourceLocation SELECTOR_SPRITE = LTXIndustries.RESOURCES.location("widget/upgrade_selector");
    private static final ResourceLocation SELECTOR_SPRITE_FOCUS = LTXIndustries.RESOURCES.location("widget/upgrade_selector_focus");
    @Nullable
    private ScrollbarWidget scrollbar;
    @Nullable
    private SelectorList<U> selectorList;

    protected UpgradesConfigScreen(M menu, Inventory inventory, Component title) {
        super(menu, inventory, title, 190, 200);
        this.inventoryLabelX = 14;
        this.inventoryLabelY = 108;
    }

    protected abstract void blitSlotSprites(GuiGraphics var1);

    protected void addWidgets() {
        this.selectorList = (SelectorList)this.addRenderableOnly((Renderable)new SelectorList(this.leftPos + 61, this.topPos + 23, this));
        this.scrollbar = (ScrollbarWidget)this.addRenderableWidget(new ScrollbarWidget(this.leftPos + 167, this.topPos + 23, 80, this.selectorList));
        this.scrollbar.reset();
        this.selectorList.reset();
    }

    protected void containerTick() {
        if (((UpgradesConfigMenu)this.menu).shouldUpdateScreen() && this.selectorList != null && this.scrollbar != null) {
            this.selectorList.reset();
            this.scrollbar.reset();
        }
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        super.renderBg(graphics, partialTick, mouseX, mouseY);
        this.blitInventoryAndHotbar(graphics, 14, 117);
        this.blitDarkPanel(graphics, 60, 22, 106, 82);
        this.blitLightPanel(graphics, 166, 22, 10, 82);
        this.blitSlotSprites(graphics);
    }

    protected void renderTooltip(GuiGraphics graphics, int x, int y) {
        if (((UpgradesConfigMenu)this.menu).getCarried().isEmpty() && this.selectorList != null && this.selectorList.renderTooltips(graphics, x, y)) {
            return;
        }
        super.renderTooltip(graphics, x, y);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (Screen.hasShiftDown() && button == 0 && this.selectorList != null && this.selectorList.onGridClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.selectorList != null && this.scrollbar != null && this.selectorList.isMouseOver(mouseX, mouseY) && this.scrollbar.moveScrollBar(scrollY)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    private static class SelectorList<U extends UpgradeBase<?, U>>
    extends BaseScrollGridRenderable<Object2IntMap.Entry<Holder<U>>> {
        private final UpgradesConfigScreen<U, ?> parent;

        SelectorList(int x, int y, UpgradesConfigScreen<U, ?> parent) {
            super(x, y, 104, 20, 1, 4);
            this.parent = parent;
        }

        @Override
        public List<Object2IntMap.Entry<Holder<U>>> getElements() {
            return ((UpgradesConfigMenu)((UpgradesConfigScreen)this.parent).menu).getRemoteUpgrades();
        }

        @Override
        public void renderElement(GuiGraphics graphics, Object2IntMap.Entry<Holder<U>> element, int posX, int posY, int gridIndex, int elementIndex, int mouseX, int mouseY) {
            int rightColor;
            int leftColor;
            UpgradeBase upgrade = (UpgradeBase)((Holder)element.getKey()).value();
            int rank = element.getIntValue();
            ResourceLocation sprite = this.isMouseOverElement(mouseX, mouseY, posX, posY) ? SELECTOR_SPRITE_FOCUS : SELECTOR_SPRITE;
            graphics.blitSprite(sprite, posX, posY, this.elementWidth(), this.elementHeight());
            UpgradeIconRenderers.renderWithSpriteFallback(graphics, upgrade.display().icon(), posX + 2, posY + 2);
            int titleX = posX + 22;
            int titleY = posY + 3;
            PoseStack poseStack = graphics.pose();
            poseStack.pushPose();
            graphics.enableScissor(titleX, titleY, titleX + 79, titleY + 9);
            double d = titleX;
            double d2 = titleY;
            Objects.requireNonNull(Minecraft.getInstance().font);
            poseStack.translate(d, d2 + (11.0 - 9.0 * 0.8) / 2.0, 0.0);
            poseStack.scale(0.8f, 0.8f, 0.8f);
            graphics.drawString(Minecraft.getInstance().font, upgrade.display().title(), 0, 0, -1, false);
            graphics.disableScissor();
            poseStack.popPose();
            float xo = 75.0f * LimaCoreMath.divideFloat((float)rank, (float)upgrade.maxRank());
            if (rank == upgrade.maxRank()) {
                leftColor = -12623888;
                rightColor = -12586799;
            } else {
                leftColor = -3063824;
                rightColor = LTXIConstants.UPGRADE_RANK_MAGENTA.argb32();
            }
            this.renderGradientBar(graphics, posX + 21, posY + 15, (float)(posX + 21) + xo, posY + 19, leftColor, rightColor);
        }

        @Override
        public void renderElementTooltip(GuiGraphics graphics, Object2IntMap.Entry<Holder<U>> element, int mouseX, int mouseY, int gridIndex, int elementIndex) {
            UpgradeBase upgrade = (UpgradeBase)((Holder)element.getKey()).value();
            int rank = element.getIntValue();
            ObjectArrayList lines = new ObjectArrayList();
            lines.add(upgrade.display().title());
            lines.add(LTXILangKeys.UPGRADE_RANK_TOOLTIP.translateArgs(new Object[]{rank, upgrade.maxRank()}).withStyle(LTXIConstants.UPGRADE_RANK_MAGENTA.chatStyle()));
            lines.add(upgrade.display().description());
            upgrade.applyEffectsTooltips(rank, ((List)lines)::add);
            lines.add(LTXILangKeys.UPGRADE_REMOVE_HINT.translate().withStyle(LTXIConstants.OUTPUT_ORANGE.chatStyle()));
            graphics.renderTooltip(Minecraft.getInstance().font, (List)lines, Optional.empty(), mouseX, mouseY);
        }

        @Override
        public void onElementClicked(Object2IntMap.Entry<Holder<U>> element, double mouseX, double mouseY, int button, int gridIndex, int elementIndex) {
            if (Screen.hasShiftDown()) {
                this.parent.sendCustomButtonData(0, LimaRegistryUtil.getNonNullRegistryId((Holder)((Holder)element.getKey())), (Supplier)LimaCoreNetworkSerializers.RESOURCE_LOCATION);
            }
        }

        private void renderGradientBar(GuiGraphics graphics, float x1, float y1, float x2, float y2, int leftColor, int rightColor) {
            Matrix4f mx4 = graphics.pose().last().pose();
            VertexConsumer buffer = graphics.bufferSource().getBuffer(RenderType.guiOverlay());
            buffer.addVertex(mx4, x1, y1, 0.0f).setColor(leftColor);
            buffer.addVertex(mx4, x1, y2, 0.0f).setColor(leftColor);
            buffer.addVertex(mx4, x2, y2, 0.0f).setColor(rightColor);
            buffer.addVertex(mx4, x2, y1, 0.0f).setColor(rightColor);
            graphics.flush();
        }
    }
}

