/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.gui.widget;

import java.util.Collection;
import java.util.List;
import liedge.limacore.util.LimaCollectionsUtil;
import liedge.ltxindustries.client.gui.widget.BaseGridRenderable;
import liedge.ltxindustries.client.gui.widget.ScrollableGUIElement;
import net.minecraft.util.Mth;

public abstract class BaseScrollGridRenderable<T>
extends BaseGridRenderable<T>
implements ScrollableGUIElement {
    private int scrollRows;
    private int scrollDelta = 1;
    private int currentScrollRow;

    protected BaseScrollGridRenderable(int x, int y, int elementWidth, int elementHeight, int gridWidth, int gridHeight) {
        super(x, y, elementWidth, elementHeight, gridWidth, gridHeight);
    }

    public void reset() {
        this.scrollRows = LimaCollectionsUtil.splitCollectionToSegments((Collection)this.getElements(), (int)this.gridWidth());
        this.scrollDelta = this.canScroll() ? (this.getHeight() - 13) / this.scrollRows : 1;
    }

    @Override
    public int elementStart() {
        return this.currentScrollRow * this.gridWidth();
    }

    @Override
    public int getScrollDelta() {
        return this.scrollDelta;
    }

    @Override
    public boolean canScroll() {
        return this.scrollRows > this.gridHeight();
    }

    @Override
    public void scrollUpdated(int scrollPosition) {
        int newScrollRow = Mth.clamp((int)(scrollPosition / this.scrollDelta), (int)0, (int)Math.max(0, this.scrollRows - 1));
        if (newScrollRow != this.currentScrollRow) {
            this.onScrollRowChanged(newScrollRow);
        }
    }

    protected void onScrollRowChanged(int newScrollRow) {
        this.currentScrollRow = newScrollRow;
    }

    public static abstract class FixedElements<T>
    extends BaseScrollGridRenderable<T> {
        private final List<T> elements;

        protected FixedElements(int x, int y, int elementWidth, int elementHeight, int gridWidth, int gridHeight, List<T> elements) {
            super(x, y, elementWidth, elementHeight, gridWidth, gridHeight);
            this.elements = elements;
            this.reset();
        }

        @Override
        public List<T> getElements() {
            return this.elements;
        }
    }
}

