/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.gui.widget;

import liedge.limacore.capability.energy.EnergyHolderBlockEntity;
import liedge.limacore.capability.energy.LimaEnergyStorage;
import liedge.limacore.capability.energy.LimaEnergyUtil;
import liedge.limacore.client.gui.FillBarWidget;
import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.util.LTXITooltipUtil;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyGaugeWidget
extends FillBarWidget.VerticalBar {
    private static final ResourceLocation BG_SPRITE = LTXIndustries.RESOURCES.location("widget/energy_bar_background");
    private static final ResourceLocation FG_SPRITE_NORMAL = LTXIndustries.RESOURCES.location("widget/energy_bar_fill");
    private static final ResourceLocation FG_SPRITE_OVERCHARGE = LTXIndustries.RESOURCES.location("widget/energy_bar_overcharge_fill");
    private final LimaEnergyStorage energyStorage;

    public EnergyGaugeWidget(LimaEnergyStorage energyStorage, int x, int y) {
        super(x, y, 12, 40, 10, 38);
        this.energyStorage = energyStorage;
    }

    public EnergyGaugeWidget(EnergyHolderBlockEntity blockEntity, int x, int y) {
        this(blockEntity.getEnergyStorage(), x, y);
    }

    protected float getFillPercentage() {
        return LimaEnergyUtil.getFillPercentage((IEnergyStorage)this.energyStorage);
    }

    protected ResourceLocation getBackgroundSprite() {
        return BG_SPRITE;
    }

    protected ResourceLocation getForegroundSprite(float fillPercentage) {
        return fillPercentage > 1.0f ? FG_SPRITE_OVERCHARGE : FG_SPRITE_NORMAL;
    }

    public boolean hasTooltip() {
        return true;
    }

    public void createWidgetTooltip(TooltipLineConsumer consumer) {
        LTXITooltipUtil.appendStorageEnergyTooltip(consumer, this.energyStorage.getEnergyStored(), this.energyStorage.getMaxEnergyStored(), this.energyStorage.getTransferRate());
        if (this.getFillPercentage() > 1.0f) {
            consumer.accept((FormattedText)LTXILangKeys.ENERGY_OVERCHARGE_TOOLTIP.translate().withStyle(LTXIConstants.HOSTILE_ORANGE.chatStyle()));
        }
    }
}

