/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.gui.widget;

import java.util.Optional;
import liedge.limacore.client.gui.FillBarWidget;
import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.blockentity.BaseFabricatorBlockEntity;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.menu.tooltip.ItemGridTooltip;
import liedge.ltxindustries.recipe.FabricatingRecipe;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

public class FabricatorProgressWidget
extends FillBarWidget.VerticalBar {
    public static final ResourceLocation BACKGROUND_SPRITE = LTXIndustries.RESOURCES.location("widget/fabricator_progress_background");
    public static final ResourceLocation FILL_SPRITE = LTXIndustries.RESOURCES.location("widget/fabricator_progress_fill");
    public static final int BACKGROUND_WIDTH = 5;
    public static final int BACKGROUND_HEIGHT = 22;
    public static final int FILL_WIDTH = 3;
    public static final int FILL_HEIGHT = 20;
    private final BaseFabricatorBlockEntity blockEntity;

    public FabricatorProgressWidget(int x, int y, BaseFabricatorBlockEntity blockEntity) {
        super(x, y, 5, 22, 3, 20);
        this.blockEntity = blockEntity;
    }

    protected float getFillPercentage() {
        int recipeEnergy = this.blockEntity.getRecipeCheck().getLastUsedRecipe((Level)Minecraft.getInstance().level).map(holder -> ((FabricatingRecipe)holder.value()).getEnergyRequired()).orElse(0);
        return LimaCoreMath.divideFloat((float)this.blockEntity.getEnergyCraftProgress(), (float)recipeEnergy);
    }

    protected ResourceLocation getBackgroundSprite() {
        return BACKGROUND_SPRITE;
    }

    protected ResourceLocation getForegroundSprite(float fillPercentage) {
        return FILL_SPRITE;
    }

    public boolean hasTooltip() {
        return this.blockEntity.isCrafting();
    }

    public void createWidgetTooltip(TooltipLineConsumer consumer) {
        Optional optional = this.blockEntity.getRecipeCheck().getLastUsedRecipe((Level)Minecraft.getInstance().level);
        if (optional.isPresent()) {
            FabricatingRecipe recipe = (FabricatingRecipe)((RecipeHolder)optional.get()).value();
            float fill = LimaCoreMath.divideFloat((float)this.blockEntity.getEnergyCraftProgress(), (float)recipe.getEnergyRequired());
            int progress = (int)(fill * 100.0f);
            consumer.accept((FormattedText)LTXILangKeys.CRAFTING_PROGRESS_TOOLTIP.translateArgs(new Object[]{progress}).withStyle(ChatFormatting.GRAY));
            consumer.accept((TooltipComponent)ItemGridTooltip.createSingle(recipe.getFabricatingResultItem(), true));
        }
    }
}

