/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.gui.widget;

import java.util.List;
import liedge.limacore.client.gui.LimaGuiUtil;
import liedge.limacore.client.gui.LimaRenderable;
import liedge.limacore.lib.math.LimaCoreMath;
import net.minecraft.client.gui.GuiGraphics;

public interface GridGUIElement<T>
extends LimaRenderable {
    public List<T> getElements();

    public int elementWidth();

    public int elementHeight();

    default public int elementStart() {
        return 0;
    }

    default public int elementEnd() {
        return Math.min(this.elementStart() + this.gridSize(), this.getElements().size());
    }

    public int gridWidth();

    public int gridHeight();

    default public int gridSize() {
        return this.gridWidth() * this.gridHeight();
    }

    default public boolean isValidGridIndex(int gridIndex) {
        return gridIndex >= 0 && gridIndex < this.gridSize();
    }

    default public boolean isValidElementIndex(int elementIndex) {
        return elementIndex >= this.elementStart() && elementIndex < this.elementEnd();
    }

    default public int getGridIndexAt(double mouseX, double mouseY) {
        int x = (int)LimaCoreMath.divideDouble((double)(mouseX - (double)this.getX()), (double)this.elementWidth());
        int y = (int)LimaCoreMath.divideDouble((double)(mouseY - (double)this.getY()), (double)this.elementHeight());
        return y * this.gridWidth() + x;
    }

    default public boolean isMouseOverElement(double mouseX, double mouseY, int elementX0, int elementY0) {
        return LimaGuiUtil.isMouseWithinArea((double)mouseX, (double)mouseY, (int)elementX0, (int)elementY0, (int)this.elementWidth(), (int)this.elementHeight());
    }

    public void renderElement(GuiGraphics var1, T var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public void renderElementTooltip(GuiGraphics var1, T var2, int var3, int var4, int var5, int var6);

    public void onElementClicked(T var1, double var2, double var4, int var6, int var7, int var8);

    default public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int start;
        if (this.getElements().isEmpty()) {
            return;
        }
        for (int i = start = this.elementStart(); i < this.elementEnd(); ++i) {
            int gridIndex = i - start;
            int posX = this.getX() + gridIndex % this.gridWidth() * this.elementWidth();
            int posY = this.getY() + gridIndex / this.gridWidth() * this.elementHeight();
            T element = this.getElements().get(i);
            this.renderElement(graphics, element, posX, posY, gridIndex, i, mouseX, mouseY);
        }
    }

    default public boolean renderTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (this.getElements().isEmpty()) {
            return true;
        }
        int gridIndex = this.getGridIndexAt(mouseX, mouseY);
        int elementIndex = this.elementStart() + gridIndex;
        if (this.isValidGridIndex(gridIndex) && this.isValidElementIndex(elementIndex)) {
            T element = this.getElements().get(elementIndex);
            this.renderElementTooltip(graphics, element, mouseX, mouseY, gridIndex, elementIndex);
        }
        return true;
    }

    default public boolean onGridClicked(double mouseX, double mouseY, int button) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (this.getElements().isEmpty()) {
            return true;
        }
        int gridIndex = this.getGridIndexAt(mouseX, mouseY);
        int elementIndex = this.elementStart() + gridIndex;
        if (this.isValidGridIndex(gridIndex) && this.isValidElementIndex(elementIndex)) {
            T element = this.getElements().get(elementIndex);
            this.onElementClicked(element, mouseX, mouseY, button, gridIndex, elementIndex);
        }
        return true;
    }
}

