/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.gui.widget;

import liedge.limacore.client.gui.LimaMenuScreen;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.blockentity.base.BlockEntityInputType;
import liedge.ltxindustries.client.gui.widget.LimaSidebarButton;
import liedge.ltxindustries.registry.game.LTXINetworkSerializers;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class OpenIOControlButton
extends LimaSidebarButton.RightSided {
    private static final ResourceLocation ITEMS_SPRITE = LTXIndustries.RESOURCES.location("widget/item_io");
    private static final ResourceLocation ENERGY_SPRITE = LTXIndustries.RESOURCES.location("widget/power_io");
    private static final ResourceLocation FLUIDS_SPRITE = LTXIndustries.RESOURCES.location("widget/fluid_io");
    private final LimaMenuScreen<?> parent;
    private final int buttonId;
    private final BlockEntityInputType inputType;
    private final ResourceLocation icon;

    public OpenIOControlButton(int x, int y, LimaMenuScreen<?> parent, int buttonId, BlockEntityInputType inputType) {
        super(x, y, (Component)BlockEntityInputType.SIDEBAR_TOOLTIP.translateArgs(new Object[]{inputType.translate()}));
        this.parent = parent;
        this.buttonId = buttonId;
        this.inputType = inputType;
        this.icon = switch (inputType) {
            default -> throw new MatchException(null, null);
            case BlockEntityInputType.ITEMS -> ITEMS_SPRITE;
            case BlockEntityInputType.ENERGY -> ENERGY_SPRITE;
            case BlockEntityInputType.FLUIDS -> FLUIDS_SPRITE;
        };
        this.setTooltip(Tooltip.create((Component)this.getMessage()));
    }

    @Override
    public void onPress(int button) {
        this.parent.sendCustomButtonData(this.buttonId, (Object)this.inputType, LTXINetworkSerializers.MACHINE_INPUT_TYPE);
    }

    @Override
    protected void renderContents(GuiGraphics graphics, int guiX, int guiY) {
        this.renderSprite(graphics, this.icon, guiX, guiY);
    }
}

