/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.gui.widget;

import liedge.limacore.client.gui.BaseLimaRenderable;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.client.gui.widget.ScrollableGUIElement;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class ScrollbarWidget
extends BaseLimaRenderable
implements NarratableEntry,
GuiEventListener {
    private static final int SCROLLER_WIDTH = 8;
    static final int SCROLLER_HEIGHT = 13;
    private static final ResourceLocation SCROLLER_SPRITE = LTXIndustries.RESOURCES.location("widget/scroller");
    private final int scrollRange;
    private final ScrollableGUIElement element;
    private boolean scrolling;
    private boolean focused;
    private int scrollPosition = 0;

    public ScrollbarWidget(int x, int y, int height, ScrollableGUIElement element) {
        super(x, y, 8, height);
        this.scrollRange = height - 13;
        this.element = element;
    }

    private void setPositionFromMouse(double mouseY) {
        int relativeMouseY = (int)mouseY - this.getY() - 6;
        this.setScrollPosition(relativeMouseY, false);
    }

    private void setScrollPosition(int scrollPosition, boolean forceUpdate) {
        if (this.scrollPosition != (scrollPosition = Mth.clamp((int)scrollPosition, (int)0, (int)this.scrollRange)) || forceUpdate) {
            this.scrollPosition = scrollPosition;
            this.element.scrollUpdated(scrollPosition);
        }
    }

    public void reset() {
        this.setScrollPosition(0, true);
        this.setFocused(false);
    }

    @Deprecated(forRemoval=true)
    public void moveScrollbar(int delta) {
        if (!this.scrolling && this.element.canScroll()) {
            this.setScrollPosition(this.scrollPosition + delta, false);
        }
    }

    public boolean moveScrollBar(double scrollWheelY) {
        if (!this.scrolling && this.element.canScroll()) {
            int delta = this.element.getScrollDelta() * (int)(-Math.signum(scrollWheelY));
            this.setScrollPosition(this.scrollPosition + delta, false);
            return true;
        }
        return false;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blitSprite(SCROLLER_SPRITE, this.getX(), this.getY() + this.scrollPosition, 8, 13);
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isMouseOver(mouseX, mouseY) && button == 0 && this.element.canScroll()) {
            this.setPositionFromMouse(mouseY);
            this.scrolling = true;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrolling = false;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling) {
            this.setPositionFromMouse(mouseY);
            return true;
        }
        return false;
    }
}

