/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.model.baked;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Axis;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import liedge.limacore.data.LimaCoreCodecs;
import net.minecraft.core.Direction;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public record BakedRotation(Vector3f pivot, Quaternionf rotation) {
    public static final Codec<BakedRotation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)LimaCoreCodecs.VECTOR3F_16X.fieldOf("pivot").forGetter(BakedRotation::pivot), (App)LimaCoreCodecs.UNIT_QUATERNION.forGetter(BakedRotation::rotation)).apply((Applicative)instance, BakedRotation::new));

    public static BakedRotation fromAxisAngle(float pivotX, float pivotY, float pivotZ, float angle, Direction.Axis axis) {
        Vector3f pivot = new Vector3f(pivotX * 0.0625f, pivotY * 0.0625f, pivotZ * 0.0625f);
        Axis rot = switch (axis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> Axis.XP;
            case Direction.Axis.Y -> Axis.YP;
            case Direction.Axis.Z -> Axis.ZP;
        };
        Quaternionf rotation = rot.rotationDegrees(angle);
        return new BakedRotation(pivot, rotation);
    }

    public void applyRotation(PoseStack poseStack) {
        poseStack.translate(this.pivot.x, this.pivot.y, this.pivot.z);
        poseStack.mulPose(this.rotation);
        poseStack.translate(-this.pivot.x, -this.pivot.y, -this.pivot.z);
    }
}

