/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.model.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import liedge.limacore.data.LimaCoreCodecs;
import liedge.limacore.lib.LimaColor;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.client.LTXIndustriesClient;
import liedge.ltxindustries.client.model.custom.SimpleTriangularGeometry;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import org.joml.Matrix4f;

public final class BubbleShieldModel
implements ResourceManagerReloadListener {
    public static final BubbleShieldModel SHIELD_MODEL = new BubbleShieldModel();
    public static final int SHIELD_POLYGON_COUNT = 122;
    private static final Codec<List<SimpleTriangularGeometry>> CODEC = SimpleTriangularGeometry.CODEC.listOf(122, 122);
    private final List<SimpleTriangularGeometry> geometries = new ObjectArrayList();

    private BubbleShieldModel() {
    }

    public void onResourceManagerReload(ResourceManager manager) {
        try (BufferedReader reader = manager.openAsReader(LTXIndustries.RESOURCES.location("misc/bubble_shield_model.json"));){
            JsonArray root = GsonHelper.parseArray((Reader)reader);
            this.geometries.clear();
            this.geometries.addAll((Collection)LimaCoreCodecs.strictDecode(CODEC, (DynamicOps)JsonOps.INSTANCE, (Object)root));
        }
        catch (JsonParseException | IOException | IllegalStateException ex) {
            LTXIndustriesClient.CLIENT_LOGGER.error("bubble_shield_model.json didn't decode correctly, it might be missing, corrupted, or modified by a data-pack. Don't do that.", ex);
            throw new IllegalStateException("Failed to loaded bubble shield model.", ex);
        }
        LTXIndustriesClient.CLIENT_LOGGER.info("Loaded bubble shield model.");
    }

    public void renderFaces(int[] geometryIndexes, VertexConsumer buffer, Matrix4f mx4, LimaColor color, float alpha) {
        for (int i : geometryIndexes) {
            this.geometries.get(i).render(buffer, mx4, color, alpha);
        }
    }
}

