/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.model.custom;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import liedge.limacore.lib.LimaColor;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.ltxindustries.client.LTXIRenderUtil;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector4f;

public class EnergyBoltModel {
    private static final double MIN_BOLT_LENGTH = 0.125;
    private static final double MAX_BOLT_LENGTH = 20.0;
    private static final Direction[] BOLT_FACES = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    private final List<BoltShape> shapes;

    private static Vector2f arcAngles(double x1, double y1, double z1, double x2, double y2, double z2) {
        double vx = x2 - x1;
        double vy = y2 - y1;
        double vz = z2 - z1;
        float yRot = LimaCoreMath.toDeg((double)Mth.atan2((double)vz, (double)vx)) - 90.0f;
        float xRot = 90.0f - LimaCoreMath.toDeg((double)Mth.atan2((double)vy, (double)LimaCoreMath.vec2Length((double)vx, (double)vz)));
        return new Vector2f(xRot, yRot);
    }

    private static Vector2f arcAngles(Vec3 a, Vec3 b) {
        return EnergyBoltModel.arcAngles(a.x, a.y, a.z, b.x, b.y, b.z);
    }

    private static Vector2f arcAngles(Vector4f a, Vector4f b) {
        return EnergyBoltModel.arcAngles(a.x, a.y, a.z, b.x, b.y, b.z);
    }

    public static EnergyBoltModel multiPointBolt(List<Vec3> boltPoints, float boltThickness) {
        Preconditions.checkArgument((boltPoints.size() >= 2 ? 1 : 0) != 0, (Object)"Energy bolt model requires at least 2 points");
        Vec3 first = boltPoints.getFirst();
        ObjectArrayList adjusted = new ObjectArrayList();
        for (Vec3 o : boltPoints) {
            adjusted.add(o.subtract(first));
        }
        BoltVertexConsumer consumer = new BoltVertexConsumer();
        for (int bi = 0; bi < adjusted.size() - 1; ++bi) {
            Vec3 boltA = (Vec3)adjusted.get(bi);
            Vec3 boltB = (Vec3)adjusted.get(bi + 1);
            float boltLength = (float)boltA.distanceTo(boltB);
            int arcs = Mth.ceil((float)boltLength) * 2;
            float arcPointDistance = LimaCoreMath.divideFloat((float)boltLength, (float)arcs);
            Vector2f boltAngle = EnergyBoltModel.arcAngles(boltA, boltB);
            Matrix4f origin = new Matrix4f();
            origin.translate((float)boltA.x, (float)boltA.y, (float)boltA.z);
            origin.rotate((Quaternionfc)Axis.YN.rotationDegrees(boltAngle.y));
            origin.rotate((Quaternionfc)Axis.XP.rotationDegrees(boltAngle.x));
            ObjectArrayList arcPoints = new ObjectArrayList();
            arcPoints.add(new Vector4f());
            for (int i = 1; i < arcs; ++i) {
                float dx = (LimaCoreMath.RANDOM.nextFloat() - LimaCoreMath.RANDOM.nextFloat()) * 0.3125f;
                float dy = arcPointDistance * (float)i;
                float dz = (LimaCoreMath.RANDOM.nextFloat() - LimaCoreMath.RANDOM.nextFloat()) * 0.3125f;
                arcPoints.add(new Vector4f(dx, dy, dz, 1.0f));
            }
            arcPoints.add(new Vector4f(0.0f, boltLength, 0.0f, 1.0f));
            Matrix4f pointMatrix = new Matrix4f();
            for (int i = 0; i < arcPoints.size() - 1; ++i) {
                pointMatrix.set((Matrix4fc)origin);
                Vector4f a = (Vector4f)arcPoints.get(i);
                Vector4f b = (Vector4f)arcPoints.get(i + 1);
                Vector2f arcAngle = EnergyBoltModel.arcAngles(a, b);
                float arcLength = (float)LimaCoreMath.distanceBetween((double)a.x, (double)a.y, (double)a.z, (double)b.x, (double)b.y, (double)b.z);
                pointMatrix.translate(a.x, a.y, a.z);
                pointMatrix.rotate((Quaternionfc)Axis.YN.rotationDegrees(arcAngle.y));
                pointMatrix.rotate((Quaternionfc)Axis.XP.rotationDegrees(arcAngle.x));
                LTXIRenderUtil.renderPositionColorCuboid(consumer, pointMatrix, -boltThickness, 0.0f, -boltThickness, boltThickness, arcLength, boltThickness, LimaColor.WHITE, 1.0f, BOLT_FACES);
            }
        }
        return new EnergyBoltModel(consumer.shapes);
    }

    public static EnergyBoltModel twoFixedPointBolt(double x1, double y1, double z1, double x2, double y2, double z2, float boltThickness) {
        float boltLength = (float)Mth.clamp((double)LimaCoreMath.distanceBetween((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2), (double)0.125, (double)20.0);
        int arcs = Mth.ceil((float)boltLength) * 2;
        float arcPointDistance = LimaCoreMath.divideFloat((float)boltLength, (float)arcs);
        Vector2f boltAngle = EnergyBoltModel.arcAngles(x1, y1, z1, x2, y2, z2);
        ObjectArrayList arcPoints = new ObjectArrayList();
        arcPoints.add(new Vector4f());
        for (int i = 1; i < arcs; ++i) {
            float dx = (LimaCoreMath.RANDOM.nextFloat() - LimaCoreMath.RANDOM.nextFloat()) * 0.3125f;
            float dy = arcPointDistance * (float)i;
            float dz = (LimaCoreMath.RANDOM.nextFloat() - LimaCoreMath.RANDOM.nextFloat()) * 0.3125f;
            arcPoints.add(new Vector4f(dx, dy, dz, 1.0f));
        }
        arcPoints.add(new Vector4f(0.0f, boltLength, 0.0f, 1.0f));
        Matrix4f origin = new Matrix4f();
        origin.rotate((Quaternionfc)Axis.YN.rotationDegrees(boltAngle.y));
        origin.rotate((Quaternionfc)Axis.XP.rotationDegrees(boltAngle.x));
        BoltVertexConsumer consumer = new BoltVertexConsumer();
        Matrix4f pointMatrix = new Matrix4f();
        for (int i = 0; i < arcPoints.size() - 1; ++i) {
            pointMatrix.set((Matrix4fc)origin);
            Vector4f a = (Vector4f)arcPoints.get(i);
            Vector4f b = (Vector4f)arcPoints.get(i + 1);
            Vector2f arcAngle = EnergyBoltModel.arcAngles(a, b);
            float arcLength = (float)LimaCoreMath.distanceBetween((double)a.x, (double)a.y, (double)a.z, (double)b.x, (double)b.y, (double)b.z);
            pointMatrix.translate(a.x, a.y, a.z);
            pointMatrix.rotate((Quaternionfc)Axis.YN.rotationDegrees(arcAngle.y));
            pointMatrix.rotate((Quaternionfc)Axis.XP.rotationDegrees(arcAngle.x));
            LTXIRenderUtil.renderPositionColorCuboid(consumer, pointMatrix, -boltThickness, 0.0f, -boltThickness, boltThickness, arcLength, boltThickness, LimaColor.WHITE, 1.0f, BOLT_FACES);
        }
        return new EnergyBoltModel(consumer.shapes);
    }

    private EnergyBoltModel(List<BoltShape> shapes) {
        this.shapes = shapes;
    }

    public void renderEnergyBolt(VertexConsumer buffer, Matrix4f mx4, LimaColor color, float alpha) {
        for (BoltShape shape : this.shapes) {
            shape.addToBuffer(buffer, mx4, color, alpha);
        }
    }

    public void renderPartialBolt(VertexConsumer buffer, Matrix4f mx4, float boltAmount, LimaColor color, float alpha) {
        int i = 0;
        while ((float)i < Math.min((float)this.shapes.size(), (float)this.shapes.size() * boltAmount)) {
            this.shapes.get(i).addToBuffer(buffer, mx4, color, alpha);
            ++i;
        }
    }

    private static class BoltVertexConsumer
    implements VertexConsumer {
        private final List<BoltShape> shapes = new ObjectArrayList();
        private final BoltQuad[] quadBuffer = new BoltQuad[4];
        private final float[][] vertexBuffer = new float[4][3];
        private int pos = 0;
        private int quadPos = 0;

        private BoltVertexConsumer() {
        }

        public VertexConsumer addVertex(float x, float y, float z) {
            float[] sub = this.vertexBuffer[this.pos];
            sub[0] = x;
            sub[1] = y;
            sub[2] = z;
            ++this.pos;
            if (this.pos == 4) {
                BoltQuad quad;
                this.pos = 0;
                float[] a = this.vertexBuffer[0];
                float[] b = this.vertexBuffer[1];
                float[] c = this.vertexBuffer[2];
                float[] d = this.vertexBuffer[3];
                this.quadBuffer[this.quadPos] = quad = new BoltQuad(a[0], a[1], a[2], b[0], b[1], b[2], c[0], c[1], c[2], d[0], d[1], d[2]);
                ++this.quadPos;
                if (this.quadPos == 4) {
                    this.quadPos = 0;
                    this.shapes.add(new BoltShape(this.quadBuffer[0], this.quadBuffer[1], this.quadBuffer[2], this.quadBuffer[3]));
                }
            }
            return this;
        }

        public VertexConsumer setColor(int red, int green, int blue, int alpha) {
            return this;
        }

        public VertexConsumer setUv(float v, float v1) {
            throw new UnsupportedOperationException();
        }

        public VertexConsumer setUv1(int i, int i1) {
            throw new UnsupportedOperationException();
        }

        public VertexConsumer setUv2(int i, int i1) {
            throw new UnsupportedOperationException();
        }

        public VertexConsumer setNormal(float v, float v1, float v2) {
            throw new UnsupportedOperationException();
        }
    }

    private record BoltShape(BoltQuad a, BoltQuad b, BoltQuad c, BoltQuad d) {
        private void addToBuffer(VertexConsumer buffer, Matrix4f mx4, LimaColor color, float alpha) {
            this.a.addToBuffer(buffer, mx4, color, alpha);
            this.b.addToBuffer(buffer, mx4, color, alpha);
            this.c.addToBuffer(buffer, mx4, color, alpha);
            this.d.addToBuffer(buffer, mx4, color, alpha);
        }
    }

    private record BoltQuad(float ax, float ay, float az, float bx, float by, float bz, float cx, float cy, float cz, float dx, float dy, float dz) {
        private void addToBuffer(VertexConsumer buffer, Matrix4f mx4, LimaColor color, float alpha) {
            buffer.addVertex(mx4, this.ax, this.ay, this.az).setColor(color.red(), color.green(), color.blue(), alpha);
            buffer.addVertex(mx4, this.bx, this.by, this.bz).setColor(color.red(), color.green(), color.blue(), alpha);
            buffer.addVertex(mx4, this.cx, this.cy, this.cz).setColor(color.red(), color.green(), color.blue(), alpha);
            buffer.addVertex(mx4, this.dx, this.dy, this.dz).setColor(color.red(), color.green(), color.blue(), alpha);
        }
    }
}

