/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.ltxindustries.client.model.entity.LTXIModelLayers;
import liedge.ltxindustries.entity.GlowstickProjectileEntity;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;

public class GlowstickProjectileModel
extends Model {
    private final ModelPart stick;

    public GlowstickProjectileModel(EntityModelSet modelSet) {
        super(RenderType::entitySolid);
        ModelPart root = modelSet.bakeLayer(LTXIModelLayers.GLOWSTICK_PROJECTILE);
        this.stick = root.getChild("stick");
    }

    public void rotateModel(GlowstickProjectileEntity entity, float partialTick) {
        this.stick.yRot = LimaCoreMath.toRad((float)(-entity.getYRot()));
        this.stick.xRot = LimaCoreMath.toRad((float)(entity.getXRot() - 90.0f));
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.stick.render(poseStack, buffer, 0xF000F0, packedOverlay);
    }

    public static LayerDefinition defineLayer() {
        MeshDefinition meshDef = new MeshDefinition();
        PartDefinition root = meshDef.getRoot();
        root.addOrReplaceChild("stick", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -4.0f, -1.0f, 2.0f, 8.0f, 2.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshDef, (int)16, (int)16);
    }
}

