/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import liedge.limacore.client.renderer.LimaCoreRenderTypes;
import liedge.limacore.lib.LimaColor;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.client.model.entity.LTXIModelLayers;
import liedge.ltxindustries.entity.OrbGrenadeEntity;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class OrbGrenadeModel
extends Model {
    public static final ResourceLocation TEXTURE = LTXIndustries.RESOURCES.textureLocation("entity", "orb_grenade");
    private static final RenderType RENDER_TYPE = RenderType.entitySolid((ResourceLocation)TEXTURE);
    private static final RenderType EMISSIVE_RENDER_TYPE = LimaCoreRenderTypes.positionTexColorSolid((ResourceLocation)TEXTURE);
    private final ModelPart body;
    private final ModelPart accents;
    private final ModelPart caps;

    public OrbGrenadeModel(EntityModelSet set) {
        super(RenderType::entitySolid);
        ModelPart root = set.bakeLayer(LTXIModelLayers.ORB_GRENADE);
        this.body = root.getChild("body");
        this.accents = root.getChild("accents");
        this.caps = root.getChild("caps");
    }

    public void animateFromEntity(OrbGrenadeEntity entity, float partialTick) {
        float xRot;
        this.body.xRot = xRot = LimaCoreMath.toRad((float)entity.lerpSpinAnimation(partialTick));
        this.accents.xRot = xRot;
        this.caps.xRot = xRot;
    }

    public void renderToBuffer(PoseStack poseStack, MultiBufferSource bufferSource, int light, LimaColor color) {
        VertexConsumer buffer = bufferSource.getBuffer(RENDER_TYPE);
        this.body.render(poseStack, buffer, light, OverlayTexture.NO_OVERLAY);
        this.caps.render(poseStack, buffer, light, OverlayTexture.NO_OVERLAY);
        buffer = bufferSource.getBuffer(EMISSIVE_RENDER_TYPE);
        this.accents.render(poseStack, buffer, 0xF000F0, OverlayTexture.NO_OVERLAY, color.argb32());
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int light, int overlay, int rgb) {
        this.body.render(poseStack, buffer, light, overlay);
        this.accents.render(poseStack, buffer, 0xF000F0, overlay, rgb);
        this.caps.render(poseStack, buffer, light, overlay);
    }

    public static LayerDefinition defineLayer() {
        MeshDefinition meshDef = new MeshDefinition();
        PartDefinition partDef = meshDef.getRoot();
        PartPose pivot = PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f);
        partDef.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -3.0f, 6.0f, 6.0f, 6.0f, CubeDeformation.NONE), pivot);
        partDef.addOrReplaceChild("caps", CubeListBuilder.create().texOffs(24, 12).addBox(-1.0f, -1.0f, -5.0f, 2.0f, 2.0f, 1.0f, CubeDeformation.NONE).texOffs(24, 12).addBox(-1.0f, -1.0f, 4.0f, 2.0f, 2.0f, 1.0f, CubeDeformation.NONE).texOffs(16, 15).addBox(4.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, CubeDeformation.NONE).texOffs(16, 15).addBox(-5.0f, -1.0f, -1.0f, 1.0f, 2.0f, 2.0f, CubeDeformation.NONE).texOffs(16, 12).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 1.0f, 2.0f, CubeDeformation.NONE).texOffs(16, 12).addBox(-1.0f, 4.0f, -1.0f, 2.0f, 1.0f, 2.0f, CubeDeformation.NONE), pivot);
        partDef.addOrReplaceChild("accents", CubeListBuilder.create().texOffs(0, 12).addBox(-2.0f, 3.0f, -2.0f, 4.0f, 1.0f, 4.0f, CubeDeformation.NONE).texOffs(0, 17).addBox(-2.0f, -2.0f, -4.0f, 4.0f, 4.0f, 1.0f, CubeDeformation.NONE).texOffs(0, 17).addBox(-2.0f, -2.0f, 3.0f, 4.0f, 4.0f, 1.0f, CubeDeformation.NONE).texOffs(0, 22).addBox(3.0f, -2.0f, -2.0f, 1.0f, 4.0f, 4.0f, CubeDeformation.NONE).texOffs(0, 22).addBox(-4.0f, -2.0f, -2.0f, 1.0f, 4.0f, 4.0f, CubeDeformation.NONE).texOffs(0, 12).addBox(-2.0f, -4.0f, -2.0f, 4.0f, 1.0f, 4.0f, CubeDeformation.NONE), pivot);
        return LayerDefinition.create((MeshDefinition)meshDef, (int)32, (int)32);
    }
}

