/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.particle;

import liedge.limacore.client.particle.LimaParticleUtil;
import liedge.limacore.lib.LimaColor;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.registry.game.LTXIParticles;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;

public class AcidDripParticle
extends TextureSheetParticle {
    private final boolean createLandingParticle;

    public static TextureSheetParticle corrosiveDripParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
        return new AcidDripParticle(level, true, x, y, z, 0.0, 0.0, 0.0);
    }

    public static TextureSheetParticle createFallParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
        return new AcidDripParticle(level, true, x, y, z, dx, dy, dz);
    }

    public static TextureSheetParticle createLandParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
        return new AcidDripParticle(level, false, x, y, z, dx, dy, dz);
    }

    private AcidDripParticle(ClientLevel level, boolean createLandingParticle, double x, double y, double z, double dx, double dy, double dz) {
        super(level, x, y, z);
        this.createLandingParticle = createLandingParticle;
        this.lifetime = createLandingParticle ? this.random.nextIntBetweenInclusive(15, 30) : this.random.nextIntBetweenInclusive(10, 16);
        this.setSize(0.01f, 0.01f);
        this.setParticleSpeed(dx, dy, dz);
        LimaParticleUtil.setColor((Particle)this, (LimaColor)LTXIConstants.ACID_GREEN);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    protected int getLightColor(float partialTick) {
        return 240;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        this.move(this.xd, this.yd, this.zd);
        if (this.createLandingParticle && this.onGround) {
            this.level.addParticle((ParticleOptions)LTXIParticles.ACID_LAND.get(), this.x, this.y, this.z, this.xd, this.yd, this.zd);
            this.remove();
        }
        this.xd *= 0.75;
        this.yd = Math.max(-3.0, this.yd - 0.065);
        this.zd *= 0.75;
    }
}

