/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.particle;

import liedge.limacore.client.particle.ColorSizeParticleOptions;
import liedge.limacore.client.particle.LimaParticleUtil;
import liedge.limacore.lib.LimaColor;
import liedge.ltxindustries.LTXIConstants;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;

public class AnimatedGlowParticle
extends SimpleAnimatedParticle {
    public static Particle colorGlitter(ColorSizeParticleOptions options, ClientLevel level, SpriteSet spriteSet, double x, double y, double z, double dx, double dy, double dz) {
        AnimatedGlowParticle particle = new AnimatedGlowParticle(level, spriteSet, options.size(), options.color(), x, y, z, dx, dy, dz);
        particle.lifetime = 20;
        return particle;
    }

    public static Particle electricSpark(SimpleParticleType type, ClientLevel level, SpriteSet spriteSet, double x, double y, double z, double dx, double dy, double dz) {
        AnimatedGlowParticle particle = new AnimatedGlowParticle(level, spriteSet, 0.75f, LTXIConstants.ELECTRIC_GREEN, x, y, z, dx, dy, dz);
        particle.lifetime = 17;
        particle.alpha = 0.9f;
        particle.friction = 0.85f;
        return particle;
    }

    public static Particle cryoSnowflake(SimpleParticleType type, ClientLevel level, SpriteSet spriteSet, double x, double y, double z, double dx, double dy, double dz) {
        return new SnowflakeParticle(level, spriteSet, 0.825f, LimaColor.WHITE, x, y, z, 0.0, 0.0, 0.0);
    }

    private AnimatedGlowParticle(ClientLevel level, SpriteSet spriteSet, float quadSize, LimaColor color, double x, double y, double z, double dx, double dy, double dz) {
        super(level, x, y, z, spriteSet, 0.0f);
        this.quadSize *= quadSize;
        this.setParticleSpeed(dx, dy, dz);
        this.setSpriteFromAge(spriteSet);
        LimaParticleUtil.setColor((Particle)this, (LimaColor)color);
    }

    public int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    private static class SnowflakeParticle
    extends AnimatedGlowParticle {
        private SnowflakeParticle(ClientLevel level, SpriteSet spriteSet, float quadSize, LimaColor color, double x, double y, double z, double dx, double dy, double dz) {
            super(level, spriteSet, quadSize, color, x, y, z, dx, dy, dz);
            this.friction = 0.95f;
            this.lifetime = this.random.nextIntBetweenInclusive(60, 120);
            this.setSpriteFromAge(spriteSet);
        }

        public void tick() {
            this.xo = this.x;
            this.yo = this.y;
            this.zo = this.z;
            this.setSprite(this.sprites.get(this.age % 20, 20));
            if (this.age++ > this.lifetime) {
                this.remove();
            } else {
                if (!this.onGround) {
                    this.xd *= (double)this.friction;
                    this.yd = Math.max(-0.1, this.yd - 0.005);
                    this.zd *= (double)this.friction;
                } else {
                    this.lifetime = this.random.nextIntBetweenInclusive(8, 14);
                }
                this.move(this.xd, this.yd, this.zd);
            }
        }
    }
}

