/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.particle;

import liedge.limacore.client.particle.LimaParticleUtil;
import liedge.limacore.lib.LimaColor;
import liedge.ltxindustries.LTXIConstants;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.CampfireSmokeParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;

public class BigColorSmokeParticle
extends CampfireSmokeParticle {
    public static Particle neuroSmokeParticle(SimpleParticleType particleType, ClientLevel level, SpriteSet spriteSet, double x, double y, double z, double dx, double dy, double dz) {
        BigColorSmokeParticle particle = new BigColorSmokeParticle(level, spriteSet, LTXIConstants.NEURO_BLUE, 1.0f, x, y, z, dx, dy, dz);
        float size = 8.0f + particle.random.nextFloat() * 6.0f;
        particle.lifetime = 30 + particle.random.nextInt(20);
        particle.quadSize *= size;
        return particle;
    }

    private BigColorSmokeParticle(ClientLevel level, SpriteSet spriteSet, LimaColor color, float size, double x, double y, double z, double dx, double dy, double dz) {
        super(level, x, y, z, dx, dy, dz, false);
        float originalSize = this.quadSize / 3.0f;
        this.quadSize = originalSize * size;
        this.friction = 0.96f;
        this.lifetime = 60 + this.random.nextInt(40);
        LimaParticleUtil.setColor((Particle)this, (LimaColor)color);
        this.setAlpha(0.9f);
        this.pickSprite(spriteSet);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ > this.lifetime) {
            this.remove();
        } else {
            this.xd *= (double)this.friction;
            this.zd *= (double)this.friction;
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            if (this.age > this.lifetime / 2) {
                float alphaChange = ((float)this.age - (float)this.lifetime / 2.0f) / (float)this.lifetime;
                this.setAlpha(1.0f - alphaChange);
            }
        }
    }

    protected int getLightColor(float partialTick) {
        return 0xF000F0;
    }
}

