/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.particle;

import liedge.limacore.client.particle.ColorParticleOptions;
import liedge.limacore.client.particle.LimaParticleUtil;
import liedge.limacore.lib.LimaColor;
import liedge.ltxindustries.registry.game.LTXIParticles;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;

public class ColorSonicBoomParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;

    public static ColorSonicBoomParticle halfSonicBoom(ColorParticleOptions options, ClientLevel level, SpriteSet spriteSet, double x, double y, double z) {
        ColorSonicBoomParticle particle = new ColorSonicBoomParticle(options, level, spriteSet, x, y, z);
        particle.lifetime = 4 + particle.random.nextInt(3);
        return particle;
    }

    public static ColorSonicBoomParticle fullSonicBoom(ColorParticleOptions options, ClientLevel level, SpriteSet spriteSet, double x, double y, double z) {
        ColorSonicBoomParticle particle = new ColorSonicBoomParticle(options, level, spriteSet, x, y, z);
        particle.lifetime = 16;
        return particle;
    }

    private ColorSonicBoomParticle(ColorParticleOptions options, ClientLevel level, SpriteSet spriteSet, double x, double y, double z) {
        super(level, x, y, z);
        this.spriteSet = spriteSet;
        this.quadSize = 1.28125f;
        this.hasPhysics = false;
        LimaParticleUtil.setColor((Particle)this, (LimaColor)options.color());
        this.setSpriteFromAge(spriteSet);
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.setSpriteFromAge(this.spriteSet);
        }
    }

    protected int getLightColor(float pPartialTick) {
        return 0xF000F0;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public static class EmitterParticle
    extends NoRenderParticle {
        private final LimaColor color;

        public EmitterParticle(ColorParticleOptions options, ClientLevel level, double x, double y, double z) {
            super(level, x, y, z);
            this.lifetime = 3;
            this.color = options.color();
        }

        public void tick() {
            if (this.age++ >= this.lifetime) {
                this.remove();
            }
            for (int i = 0; i < 3; ++i) {
                double px = this.x + (this.random.nextDouble() - this.random.nextDouble()) * 4.25;
                double py = this.y + (this.random.nextDouble() - this.random.nextDouble()) * 4.25;
                double pz = this.z + (this.random.nextDouble() - this.random.nextDouble()) * 4.25;
                this.level.addAlwaysVisibleParticle((ParticleOptions)new ColorParticleOptions(LTXIParticles.COLOR_HALF_SONIC_BOOM, this.color), true, px, py, pz, 0.0, 0.0, 0.0);
            }
        }
    }
}

