/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import liedge.limacore.client.particle.ColorParticleOptions;
import liedge.limacore.client.particle.CustomRenderTypeParticle;
import liedge.limacore.lib.LimaColor;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.ltxindustries.client.model.custom.EnergyBoltModel;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class FixedElectricBoltParticle
extends CustomRenderTypeParticle {
    private final LimaColor boltColor;
    private final EnergyBoltModel boltA;
    private final EnergyBoltModel boltB;
    private EnergyBoltModel boltToRender;

    @Nullable
    public static FixedElectricBoltParticle create(ColorParticleOptions options, ClientLevel level, double x1, double y1, double z1, double x2, double y2, double z2) {
        double length = LimaCoreMath.distanceBetween((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
        return length <= 100.0 ? new FixedElectricBoltParticle(level, x1, y1, z1, x2, y2, z2, options.color(), length) : null;
    }

    private FixedElectricBoltParticle(ClientLevel level, double x1, double y1, double z1, double x2, double y2, double z2, LimaColor boltColor, double length) {
        super(level, x1, y1, z1);
        this.boltColor = boltColor;
        this.boltA = EnergyBoltModel.twoFixedPointBolt(x1, y1, z1, x2, y2, z2, 0.015625f);
        this.boltB = EnergyBoltModel.twoFixedPointBolt(x1, y1, z1, x2, y2, z2, 0.015625f);
        this.boltToRender = this.boltA;
        this.setBoundingBox(AABB.ofSize((Vec3)this.getPos(), (double)length, (double)length, (double)length));
        this.lifetime = this.random.nextIntBetweenInclusive(6, 12);
        this.hasPhysics = false;
    }

    public void tick() {
        if (this.age++ >= this.lifetime) {
            this.remove();
        }
        this.boltToRender = (this.age & 1) == 0 ? this.boltA : this.boltB;
    }

    protected void renderParticle(VertexConsumer buffer, Matrix4f mx4, Camera camera, float partialTicks) {
        this.boltToRender.renderEnergyBolt(buffer, mx4, this.boltColor, 0.85f);
    }

    protected RenderType getCustomRenderType() {
        return RenderType.lightning();
    }
}

