/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.particle;

import liedge.limacore.client.particle.ColorParticleOptions;
import liedge.limacore.client.particle.ColorSizeParticleOptions;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.ltxindustries.client.particle.GrenadeExplosionParticleOptions;
import liedge.ltxindustries.lib.weapons.GrenadeType;
import liedge.ltxindustries.registry.game.LTXIParticles;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GrenadeExplosionParticle
extends NoRenderParticle {
    private final GrenadeType grenadeElement;
    private final double explosionSize;

    public GrenadeExplosionParticle(GrenadeExplosionParticleOptions options, ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.grenadeElement = options.element();
        this.explosionSize = options.explosionSize();
    }

    public void tick() {
        this.level.addAlwaysVisibleParticle((ParticleOptions)new ColorSizeParticleOptions(LTXIParticles.COLOR_FLASH, this.grenadeElement.getColor(), (float)this.explosionSize), true, this.x, this.y, this.z, 0.0, 0.0, 0.0);
        switch (this.grenadeElement) {
            case EXPLOSIVE: {
                this.level.addParticle((ParticleOptions)new ColorParticleOptions(LTXIParticles.HALF_SONIC_BOOM_EMITTER, this.grenadeElement.getColor()), true, this.x, this.y, this.z, 0.0, 0.0, 0.0);
                break;
            }
            case CRYO: {
                this.cryoSnowflakeExplosion();
                break;
            }
            case ELECTRIC: {
                this.particleBall((ParticleOptions)LTXIParticles.MINI_ELECTRIC_SPARK.get(), 0.5, 1);
                break;
            }
            case ACID: {
                this.acidExplosion();
                break;
            }
            case NEURO: {
                this.neuroExplosion();
            }
        }
        this.remove();
    }

    private boolean isNotAirAndHasAirAbove(BlockPos pos) {
        if (this.level.hasChunkAt(pos)) {
            return !this.level.getBlockState(pos).isAir() && this.level.getBlockState(pos.above()).isAir();
        }
        return false;
    }

    private void cryoSnowflakeExplosion() {
        this.particleBallManualSpeed((ParticleOptions)LTXIParticles.CRYO_SNOWFLAKE.get(), 0.325, 1);
        BlockPos.betweenClosedStream((AABB)AABB.ofSize((Vec3)this.getPos(), (double)3.0, (double)3.0, (double)3.0)).filter(this::isNotAirAndHasAirAbove).forEach(blockPos -> {
            VoxelShape shape = this.level.getBlockState(blockPos).getCollisionShape((BlockGetter)this.level, blockPos);
            double xOffset = this.random.nextDouble();
            double zOffset = this.random.nextDouble();
            double px = (double)blockPos.getX() + xOffset;
            double py = (double)blockPos.getY() + shape.toAabbs().stream().filter(box -> xOffset >= box.minX && xOffset <= box.maxX && zOffset >= box.minZ && zOffset <= box.maxZ).mapToDouble(box -> box.maxY).max().orElse(0.0);
            double pz = (double)blockPos.getZ() + zOffset;
            this.level.addParticle((ParticleOptions)LTXIParticles.GROUND_ICICLE.get(), false, px, py, pz, 0.0, 0.0, 0.0);
        });
    }

    private void acidExplosion() {
        this.particleBall((ParticleOptions)LTXIParticles.ACID_FALL.get(), 0.755, 2);
    }

    private void neuroExplosion() {
        for (int i = 0; i < 16; ++i) {
            double dx = (this.random.nextDouble() - this.random.nextDouble()) * 0.2;
            double dz = (this.random.nextDouble() - this.random.nextDouble()) * 0.2;
            this.level.addParticle((ParticleOptions)LTXIParticles.NEURO_SMOKE.get(), true, this.x, this.y + 0.25, this.z, dx, 0.05, dz);
        }
    }

    private void particleBallManualSpeed(ParticleOptions options, double speed, int size) {
        for (int i = -size; i <= size; ++i) {
            for (int j = -size; j <= size; ++j) {
                for (int k = -size; k <= size; ++k) {
                    double dx = (double)j + (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
                    double dy = (double)i + (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
                    double dz = (double)k + (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
                    double d1 = LimaCoreMath.vec3Length((double)dx, (double)dy, (double)dz) / speed + this.random.nextGaussian() * 0.05;
                    Particle particle = Minecraft.getInstance().particleEngine.createParticle(options, this.x, this.y, this.z, 0.0, 0.0, 0.0);
                    if (particle == null) continue;
                    particle.setParticleSpeed(dx / d1, Math.min(dy / d1, 0.5), dz / d1);
                }
            }
        }
    }

    private void particleBall(ParticleOptions particle, double speed, int size) {
        for (int i = -size; i <= size; ++i) {
            for (int j = -size; j <= size; ++j) {
                for (int k = -size; k <= size; ++k) {
                    double dx = (double)j + (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
                    double dy = (double)i + (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
                    double dz = (double)k + (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
                    double d1 = LimaCoreMath.vec3Length((double)dx, (double)dy, (double)dz) / speed + this.random.nextGaussian() * 0.05;
                    this.level.addAlwaysVisibleParticle(particle, true, this.x, this.y, this.z, dx / d1, Math.min(dy / d1, 0.5), dz / d1);
                }
            }
        }
    }
}

