/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import liedge.limacore.lib.ModResources;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.ltxindustries.client.LTXIRenderUtil;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class GroundIcicleParticle
extends Particle {
    private static final ResourceLocation ICE_SPRITE_LOCATION = ModResources.MC.location("block/ice");
    private static final Direction[] NOT_DOWN = new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
    private final TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(ICE_SPRITE_LOCATION);
    private final float baseSize = 0.4f + this.random.nextFloat() * 0.6f;
    private int light;
    private int prevAge;

    public GroundIcicleParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z) {
        super(level, x, y, z);
        this.lifetime = this.random.nextIntBetweenInclusive(24, 30);
        this.hasPhysics = false;
        this.setSize(0.5f, 0.5f);
        this.light = this.getLightColor(0.0f);
    }

    public void tick() {
        this.prevAge = this.age;
        super.tick();
        this.light = this.getLightColor(0.0f);
    }

    protected int getLightColor(float partialTick) {
        BlockPos pos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        if (this.level.hasChunkAt(pos)) {
            BlockState state = this.level.getBlockState(pos);
            if (state.emissiveRendering((BlockGetter)this.level, pos)) {
                return 0xF000F0;
            }
            int blockLight = Math.max(this.level.getBrightness(LightLayer.BLOCK, pos), state.getLightEmission((BlockGetter)this.level, pos));
            int skyLight = Math.max(8, this.level.getBrightness(LightLayer.SKY, pos));
            return LightTexture.pack((int)blockLight, (int)skyLight);
        }
        return LightTexture.pack((int)0, (int)8);
    }

    public void render(VertexConsumer buffer, Camera camera, float partialTick) {
        Vec3 camPos = camera.getPosition();
        float px = (float)(Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - camPos.x);
        float py = (float)(Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - camPos.y);
        float pz = (float)(Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - camPos.z);
        Matrix4f mx4 = new Matrix4f();
        mx4.translate(px, py, pz);
        mx4.scale(this.baseSize);
        float ageLerp = LimaCoreMath.divideFloatLerp((float)partialTick, (float)this.prevAge, (float)this.age, (float)this.lifetime);
        float sizeFade = ageLerp <= 0.2f ? ageLerp / 0.2f : 1.0f - (ageLerp / 0.8f - 0.25f) * 0.333f;
        float xz11 = -0.0625f * sizeFade;
        float xz21 = 0.0625f * sizeFade;
        float y21 = 0.4375f * sizeFade;
        float xz12 = -0.03125f * sizeFade;
        float xz22 = 0.03125f * sizeFade;
        float y12 = 0.4375f * sizeFade;
        float y22 = 0.75f * sizeFade;
        this.renderBlockFormatCuboid(buffer, mx4, xz11, 0.0f, xz11, xz21, y21, xz21, this.sprite.getU(0.5f), this.sprite.getU(0.625f), this.sprite.getV(0.5f), this.sprite.getV(0.625f), this.sprite.getU(0.5f), this.sprite.getU(0.625f), this.sprite.getV(0.5625f), this.sprite.getV(1.0f), this.light, 1.0f, 1.0f, 1.0f, 0.85f, LTXIRenderUtil.ALL_SIDES);
        this.renderBlockFormatCuboid(buffer, mx4, xz12, y12, xz12, xz22, y22, xz22, this.sprite.getU(0.5f), this.sprite.getU(0.5625f), this.sprite.getV(0.5f), this.sprite.getV(0.5625f), this.sprite.getU(0.5f), this.sprite.getU(0.5625f), this.sprite.getV(0.25f), this.sprite.getV(0.5625f), this.light, 1.0f, 1.0f, 1.0f, 0.85f, NOT_DOWN);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.TERRAIN_SHEET;
    }

    private void renderBlockFormatCuboid(VertexConsumer buffer, Matrix4f mx4, float x1, float y1, float z1, float x2, float y2, float z2, float u0A, float u1A, float udV0, float udV1, float ewU0, float ewU1, float hV0, float hV1, int light, float red, float green, float blue, float alpha, Direction[] sides) {
        int lu0 = light & 0xFFFF;
        int lu1 = light >> 16 & 0xFFFF;
        block8: for (Direction side : sides) {
            switch (side) {
                case UP: {
                    buffer.addVertex(mx4, x1, y2, z2).setUv(u0A, udV1).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    buffer.addVertex(mx4, x2, y2, z2).setUv(u1A, udV1).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    buffer.addVertex(mx4, x2, y2, z1).setUv(u1A, udV0).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    buffer.addVertex(mx4, x1, y2, z1).setUv(u0A, udV0).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    continue block8;
                }
                case DOWN: {
                    buffer.addVertex(mx4, x1, y1, z1).setUv(u0A, udV1).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    buffer.addVertex(mx4, x2, y1, z1).setUv(u1A, udV1).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    buffer.addVertex(mx4, x2, y1, z2).setUv(u1A, udV0).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    buffer.addVertex(mx4, x1, y1, z2).setUv(u0A, udV0).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    continue block8;
                }
                case NORTH: {
                    buffer.addVertex(mx4, x2, y1, z1).setUv(u0A, hV1).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    buffer.addVertex(mx4, x1, y1, z1).setUv(u1A, hV1).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    buffer.addVertex(mx4, x1, y2, z1).setUv(u1A, hV0).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    buffer.addVertex(mx4, x2, y2, z1).setUv(u0A, hV0).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    continue block8;
                }
                case SOUTH: {
                    buffer.addVertex(mx4, x2, y2, z2).setUv(u1A, hV0).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    buffer.addVertex(mx4, x1, y2, z2).setUv(u0A, hV0).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    buffer.addVertex(mx4, x1, y1, z2).setUv(u0A, hV1).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    buffer.addVertex(mx4, x2, y1, z2).setUv(u1A, hV1).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    continue block8;
                }
                case EAST: {
                    buffer.addVertex(mx4, x2, y1, z2).setUv(ewU0, hV1).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    buffer.addVertex(mx4, x2, y1, z1).setUv(ewU1, hV1).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    buffer.addVertex(mx4, x2, y2, z1).setUv(ewU1, hV0).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    buffer.addVertex(mx4, x2, y2, z2).setUv(ewU0, hV0).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    continue block8;
                }
                case WEST: {
                    buffer.addVertex(mx4, x1, y2, z2).setUv(ewU1, hV0).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    buffer.addVertex(mx4, x1, y2, z1).setUv(ewU0, hV0).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    buffer.addVertex(mx4, x1, y1, z1).setUv(ewU0, hV1).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                    buffer.addVertex(mx4, x1, y1, z2).setUv(ewU1, hV1).setColor(red, green, blue, alpha).setUv2(lu0, lu1);
                }
            }
        }
    }
}

