/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import liedge.limacore.client.particle.ColorParticleOptions;
import liedge.limacore.client.particle.CustomRenderTypeParticle;
import liedge.limacore.lib.LimaColor;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.limacore.lib.math.LimaRoundingMode;
import liedge.ltxindustries.client.LTXIRenderUtil;
import liedge.ltxindustries.client.renderer.LTXIRenderTypes;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;

public class LightfragTracerParticle
extends CustomRenderTypeParticle {
    private static final float LIGHTFRAG_HALF_SIZE = 0.015625f;
    private final Quaternionf xRot;
    private final Quaternionf yRot;
    private final LimaColor color;
    private final float trailLength;

    @Nullable
    public static Particle createLightfragTracer(ColorParticleOptions options, ClientLevel level, double x1, double y1, double z1, double x2, double y2, double z2) {
        Vec3 start = new Vec3(x1, y1, z1);
        Vec3 end = new Vec3(x2, y2, z2);
        float tracerDistance = (float)start.distanceTo(end);
        if (tracerDistance >= 2.0f && tracerDistance <= 215.0f) {
            return new LightfragTracerParticle(level, start, end, options.color(), tracerDistance);
        }
        return null;
    }

    private LightfragTracerParticle(ClientLevel level, Vec3 start, Vec3 end, LimaColor color, float tracerDistance) {
        super(level, start.x, start.y, start.z);
        Vector2f angles = LimaCoreMath.xyRotBetweenPoints((Vec3)start, (Vec3)end);
        int n = LimaCoreMath.round((double)((double)tracerDistance / 20.0), (LimaRoundingMode)LimaRoundingMode.NATURAL) * 2;
        this.lifetime = Mth.clamp((int)n, (int)2, (int)12);
        this.trailLength = 0.75f * (float)this.lifetime;
        Vec3 motion = LimaCoreMath.createMotionVector((Vector2f)angles, (double)1.0);
        start = start.add(motion.scale((double)this.trailLength));
        this.setPos(start.x, start.y, start.z);
        motion = motion.scale(LimaCoreMath.divideDouble((double)(tracerDistance - this.trailLength), (double)this.lifetime));
        this.setParticleSpeed(motion.x, motion.y, motion.z);
        this.xRot = Axis.XP.rotationDegrees(angles.x);
        this.yRot = Axis.YP.rotationDegrees(-angles.y);
        this.color = color;
        this.hasPhysics = false;
    }

    public AABB getRenderBoundingBox(float partialTicks) {
        return AABB.INFINITE;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            this.move(this.xd, this.yd, this.zd);
        }
    }

    protected final void renderParticle(VertexConsumer buffer, Matrix4f mx4, Camera camera, float partialTicks) {
        float a2;
        float a1;
        if (this.age == 0) {
            return;
        }
        mx4.rotate((Quaternionfc)this.yRot);
        mx4.rotate((Quaternionfc)this.xRot);
        if (this.age == 1) {
            a1 = partialTicks;
            a2 = partialTicks * 0.4f;
        } else {
            a1 = 1.0f;
            a2 = 0.4f;
        }
        LTXIRenderUtil.renderPositionColorCuboid(buffer, mx4, -0.015625f, -0.015625f, 0.0f, 0.015625f, 0.015625f, 0.125f, this.color, a1, LTXIRenderUtil.ALL_SIDES);
        LTXIRenderUtil.renderPositionColorCuboid(buffer, mx4, -0.015625f, -0.015625f, -this.trailLength, 0.015625f, 0.015625f, 0.0f, this.color, a2, LTXIRenderUtil.ALL_SIDES);
    }

    protected RenderType getCustomRenderType() {
        return LTXIRenderTypes.POSITION_COLOR_QUADS;
    }
}

