/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.particle;

import liedge.limacore.client.particle.ColorParticleOptions;
import liedge.limacore.lib.LimaColor;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.ltxindustries.registry.game.LTXIParticles;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RailgunBoltParticle
extends NoRenderParticle {
    private final Vec3 start;
    private final Vec3 direction;
    private final int beamSegments;
    private final LimaColor color;

    @Nullable
    public static RailgunBoltParticle create(ColorParticleOptions options, ClientLevel level, double x1, double y1, double z1, double x2, double y2, double z2) {
        Vec3 end = new Vec3(x2, y2, z2);
        Vec3 start = new Vec3(x1, y1, z1);
        Vec3 path = end.subtract(start);
        double length = path.length();
        return length <= 100.0 ? new RailgunBoltParticle(level, start, path.normalize(), Mth.ceil((double)length), options.color()) : null;
    }

    private RailgunBoltParticle(ClientLevel level, Vec3 start, Vec3 direction, int beamSegments, LimaColor color) {
        super(level, start.x, start.y, start.z);
        this.start = start;
        this.direction = direction;
        this.beamSegments = beamSegments;
        this.color = color;
    }

    public void tick() {
        if (this.age == 0) {
            ColorParticleOptions options = new ColorParticleOptions(LTXIParticles.COLOR_FULL_SONIC_BOOM, this.color);
            for (int i = 0; i < this.beamSegments; ++i) {
                double px = this.start.x + this.direction.x * (double)i;
                double py = this.start.y + this.direction.y * (double)i;
                double pz = this.start.z + this.direction.z * (double)i;
                this.level.addAlwaysVisibleParticle((ParticleOptions)options, true, px, py, pz, 0.0, 0.0, 0.0);
            }
        } else if (this.age >= 10) {
            float xRot = LimaCoreMath.getXRot((Vec3)this.direction);
            float yRot = LimaCoreMath.getYRot((Vec3)this.direction);
            for (int i = 0; i < this.beamSegments; ++i) {
                double px = this.start.x + this.direction.x * (double)i;
                double py = this.start.y + this.direction.y * (double)i;
                double pz = this.start.z + this.direction.z * (double)i;
                float xo0 = (this.random.nextFloat() - this.random.nextFloat()) * 0.3f;
                float yo0 = (this.random.nextFloat() - this.random.nextFloat()) * 0.3f;
                float xo1 = (this.random.nextFloat() - this.random.nextFloat()) * 1.1f;
                float yo1 = (this.random.nextFloat() - this.random.nextFloat()) * 1.1f;
                Vec3 arcStart = LimaCoreMath.relativePointToRotations((float)xRot, (float)yRot, (double)xo0, (double)yo0, (double)0.0).add(px, py, pz);
                Vec3 arcEnd = LimaCoreMath.relativePointToRotations((float)xRot, (float)yRot, (double)xo1, (double)yo1, (double)1.0).add(px, py, pz);
                this.level.addAlwaysVisibleParticle((ParticleOptions)new ColorParticleOptions(LTXIParticles.FIXED_ELECTRIC_BOLT, this.color), true, arcStart.x, arcStart.y, arcStart.z, arcEnd.x, arcEnd.y, arcEnd.z);
            }
            this.remove();
            return;
        }
        ++this.age;
    }
}

