/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import liedge.limacore.lib.LimaColor;
import liedge.limacore.lib.TickTimer;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.limacore.util.LimaCollectionsUtil;
import liedge.ltxindustries.client.LTXIRenderUtil;
import liedge.ltxindustries.client.model.custom.BubbleShieldModel;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public final class BubbleShieldRenderer {
    public static final BubbleShieldRenderer SHIELD_RENDERER = new BubbleShieldRenderer();
    private final List<FadeAnimation> animations = new ObjectArrayList();

    private BubbleShieldRenderer() {
        ArrayDeque deque = new ArrayDeque();
        IntList indexes = LimaCollectionsUtil.toIntList((IntStream)IntStream.range(0, 122));
        IntLists.shuffle((IntList)indexes, (Random)LimaCoreMath.RANDOM).forEach(deque::push);
        for (int i = 0; i < 16; ++i) {
            int n = Math.min(deque.size(), 8);
            int[] geometryIndexes = new int[n];
            for (int j = 0; j < n; ++j) {
                geometryIndexes[j] = (Integer)deque.pop();
            }
            this.animations.add(new FadeAnimation(geometryIndexes));
        }
    }

    public void tickRenderer() {
        this.animations.forEach(FadeAnimation::tick);
    }

    public void renderBubbleShield(PoseStack poseStack, VertexConsumer buffer, LimaColor color, float partialTick) {
        Matrix4f mx4 = poseStack.last().pose();
        this.animations.forEach(animation -> animation.putInBuffer(buffer, mx4, color, partialTick));
    }

    private static class FadeAnimation {
        private final int[] geometryIndexes;
        private final TickTimer animationTimer = new TickTimer();

        private FadeAnimation(int[] geometryIndexes) {
            this.geometryIndexes = geometryIndexes;
        }

        private void tick() {
            this.animationTimer.tickTimer();
            if (this.animationTimer.getTimerState() == TickTimer.State.STOPPED && LimaCoreMath.rollRandomChance((double)0.08)) {
                this.animationTimer.startTimer(LimaCoreMath.nextIntBetweenInclusive((int)12, (int)18), false);
            }
        }

        private void putInBuffer(VertexConsumer buffer, Matrix4f mx4, LimaColor color, float partialTick) {
            float alpha = this.animationTimer.getTimerState() == TickTimer.State.STOPPED ? 0.125f : Mth.clamp((float)LTXIRenderUtil.linearThresholdCurve(this.animationTimer.lerpPausedProgress(partialTick), 0.3f), (float)0.125f, (float)0.8f);
            BubbleShieldModel.SHIELD_MODEL.renderFaces(this.geometryIndexes, buffer, mx4, color, alpha);
        }
    }
}

