/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer;

import liedge.limacore.lib.math.LimaCoreMath;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.fml.common.asm.enumextension.EnumProxy;

public final class LTXIArmPoses {
    private static final float UPPER_PITCH_LIMIT = LimaCoreMath.toRad((float)80.0f);
    private static final float SHIELD_LOWER_PITCH_LIMIT = LimaCoreMath.toRad((float)25.0f);
    private static final float MAIN_YAW_OFFSET = LimaCoreMath.toRad((float)6.0f);
    private static final float OFFHAND_YAW_OFFSET = LimaCoreMath.toRad((float)35.0f);
    private static final float MAIN_PITCH_OFFSET = LimaCoreMath.toRad((float)3.0f);
    public static final EnumProxy<HumanoidModel.ArmPose> TWO_HANDED_WEAPON = new EnumProxy(HumanoidModel.ArmPose.class, new Object[]{true, LTXIArmPoses::twoHandedPose});
    public static final EnumProxy<HumanoidModel.ArmPose> ONE_HANDED_WEAPON = new EnumProxy(HumanoidModel.ArmPose.class, new Object[]{false, LTXIArmPoses::oneHandedPose});
    public static final EnumProxy<HumanoidModel.ArmPose> WEAPON_SHIELD_POSE = new EnumProxy(HumanoidModel.ArmPose.class, new Object[]{false, LTXIArmPoses::weaponShieldPose});

    private LTXIArmPoses() {
    }

    private static void twoHandedPose(HumanoidModel<?> model, LivingEntity entity, HumanoidArm arm) {
        boolean rightHanded = arm == HumanoidArm.RIGHT;
        ModelPart mainArm = rightHanded ? model.rightArm : model.leftArm;
        ModelPart offArm = rightHanded ? model.leftArm : model.rightArm;
        mainArm.yRot = model.head.yRot + (rightHanded ? -MAIN_YAW_OFFSET : MAIN_YAW_OFFSET);
        offArm.yRot = model.head.yRot + (rightHanded ? OFFHAND_YAW_OFFSET : -OFFHAND_YAW_OFFSET);
        float armPitch = Mth.clamp((float)model.head.xRot, (float)(-UPPER_PITCH_LIMIT), (float)UPPER_PITCH_LIMIT) - 1.5707964f;
        mainArm.xRot = armPitch + MAIN_PITCH_OFFSET;
        offArm.xRot = armPitch;
    }

    private static void oneHandedPose(HumanoidModel<?> model, LivingEntity entity, HumanoidArm arm) {
        boolean rightHanded = arm == HumanoidArm.RIGHT;
        ModelPart mainArm = rightHanded ? model.rightArm : model.leftArm;
        mainArm.yRot = model.head.yRot + (rightHanded ? -MAIN_YAW_OFFSET : MAIN_YAW_OFFSET);
        float armPitch = Mth.clamp((float)model.head.xRot, (float)(-UPPER_PITCH_LIMIT), (float)UPPER_PITCH_LIMIT) - 1.5707964f;
        mainArm.xRot = armPitch + MAIN_PITCH_OFFSET;
    }

    private static void weaponShieldPose(HumanoidModel<?> model, LivingEntity entity, HumanoidArm arm) {
        boolean rightHanded = arm == HumanoidArm.RIGHT;
        ModelPart mainArm = rightHanded ? model.rightArm : model.leftArm;
        mainArm.zRot = 1.5707964f;
        float armYaw = (model.head.yRot - 1.5707964f) * (float)(rightHanded ? 1 : -1);
        mainArm.xRot = armYaw - MAIN_YAW_OFFSET;
        float headXRot = model.head.xRot;
        float armPitch = rightHanded ? -Mth.clamp((float)headXRot, (float)(-UPPER_PITCH_LIMIT), (float)SHIELD_LOWER_PITCH_LIMIT) : (float)Math.PI + Mth.clamp((float)(-headXRot), (float)(-SHIELD_LOWER_PITCH_LIMIT), (float)UPPER_PITCH_LIMIT);
        mainArm.yRot = armPitch + 0.261799f;
    }
}

