/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import liedge.limacore.client.renderer.LimaCoreRenderTypes;
import liedge.ltxindustries.LTXIndustries;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import org.joml.Matrix4f;

public final class LTXIRenderTypes {
    private static final RenderStateShard.TexturingStateShard FABRICATOR_WIREFRAME_TEXTURING = new RenderStateShard.TexturingStateShard("fabricator_preview_texturing", LTXIRenderTypes::setupFabricatorWireframeTexturing, RenderSystem::resetTextureMatrix);
    public static final RenderType POSITION_COLOR_TRIANGLES = LTXIRenderTypes.positionColorTranslucent(VertexFormat.Mode.TRIANGLES);
    public static final RenderType POSITION_COLOR_QUADS = LTXIRenderTypes.positionColorTranslucent(VertexFormat.Mode.QUADS);
    public static final RenderType LOCK_ON_INDICATOR = RenderType.create((String)"lock_on_indicator", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)512, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(LimaCoreRenderTypes.POSITION_TEX_COLOR_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(LTXIndustries.RESOURCES.textureLocation("misc", "target_triangle"), false, false)).setDepthTestState(RenderStateShard.NO_DEPTH_TEST).setCullState(RenderStateShard.NO_CULL).createCompositeState(false));
    public static final RenderType FABRICATOR_WIREFRAME = RenderType.create((String)"fabricator_wireframe", (VertexFormat)DefaultVertexFormat.POSITION_TEX_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)false, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_ENTITY_GLINT_DIRECT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(LTXIndustries.RESOURCES.textureLocation("entity", "fabricator_wireframe"), false, false)).setTransparencyState(RenderStateShard.GLINT_TRANSPARENCY).setWriteMaskState(RenderStateShard.COLOR_WRITE).setOutputState(RenderStateShard.ITEM_ENTITY_TARGET).setTexturingState(FABRICATOR_WIREFRAME_TEXTURING).createCompositeState(false));
    public static final RenderType GUI_TRIANGLE_STRIP = RenderType.create((String)"position_color_triangle_strip", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.TRIANGLE_STRIP, (int)512, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_GUI_SHADER).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).createCompositeState(false));

    private LTXIRenderTypes() {
    }

    private static RenderType positionColorTranslucent(VertexFormat.Mode mode) {
        RenderType.CompositeState state = RenderType.CompositeState.builder().setShaderState(RenderStateShard.POSITION_COLOR_SHADER).setTransparencyState(RenderStateShard.TRANSLUCENT_TRANSPARENCY).createCompositeState(false);
        return RenderType.create((String)("position_color_" + mode.name()), (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)mode, (int)1536, (boolean)false, (boolean)true, (RenderType.CompositeState)state);
    }

    private static void setupFabricatorWireframeTexturing() {
        long time = (long)((double)Util.getMillis() * 4.0);
        float x = (float)(time % 144000L) / 144000.0f;
        float y = (float)(time % 144000L) / 144000.0f;
        Matrix4f mx4 = new Matrix4f().translation(-x, y, 0.0f).scale(8.0f);
        RenderSystem.setTextureMatrix((Matrix4f)mx4);
    }
}

