/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Set;
import liedge.limacore.client.EmptyVertexConsumer;
import liedge.limacore.client.LimaBlockEntityRenderer;
import liedge.ltxindustries.blockentity.BaseFabricatorBlockEntity;
import liedge.ltxindustries.client.renderer.LTXIRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BaseFabricatorRenderer
extends LimaBlockEntityRenderer<BaseFabricatorBlockEntity> {
    private static final Set<VertexFormat> VALID_WIREFRAME_FORMATS = Set.of(DefaultVertexFormat.BLOCK, DefaultVertexFormat.NEW_ENTITY, DefaultVertexFormat.POSITION_TEX_COLOR);
    private final double xOffset;
    private final double yOffset;

    public BaseFabricatorRenderer(BlockEntityRendererProvider.Context context, double xOffset, double yOffset) {
        super(context);
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public void render(BaseFabricatorBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        ItemStack previewItem = blockEntity.getClientPreviewItem();
        if (!previewItem.isEmpty()) {
            poseStack.pushPose();
            Direction facing = (Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            poseStack.translate(0.5, this.yOffset, 0.5);
            float angle = switch (facing) {
                case Direction.SOUTH -> 180.0f;
                case Direction.EAST -> -90.0f;
                case Direction.WEST -> 90.0f;
                default -> 0.0f;
            };
            poseStack.mulPose(Axis.YP.rotationDegrees(angle));
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            poseStack.translate(this.xOffset, 0.0, 0.0);
            poseStack.scale(0.4375f, 0.4375f, 0.4375f);
            MultiBufferSource wireframeBufferSource = renderType -> {
                if (blockEntity.isCrafting()) {
                    return VALID_WIREFRAME_FORMATS.contains(renderType.format()) ? bufferSource.getBuffer(LTXIRenderTypes.FABRICATOR_WIREFRAME) : EmptyVertexConsumer.EMPTY_VERTEX_CONSUMER;
                }
                return bufferSource.getBuffer(renderType);
            };
            this.itemRenderer.renderStatic(previewItem, ItemDisplayContext.FIXED, light, overlay, poseStack, wireframeBufferSource, (Level)Minecraft.getInstance().level, 0);
            poseStack.popPose();
        }
    }
}

