/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import liedge.limacore.lib.LimaColor;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.blockentity.RailgunTurretBlockEntity;
import liedge.ltxindustries.client.LTXIRenderUtil;
import liedge.ltxindustries.client.renderer.blockentity.TurretRenderer;
import liedge.ltxindustries.registry.game.LTXIBlocks;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.level.ItemLike;
import org.joml.Matrix4f;

public class RailgunTurretRenderer
extends TurretRenderer<RailgunTurretBlockEntity> {
    private static final float LASER_RADIUS = 0.015625f;

    public RailgunTurretRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    protected ItemLike getModelItem() {
        return LTXIBlocks.RAILGUN_TURRET;
    }

    @Override
    protected double gunsYPivot() {
        return 1.75;
    }

    @Override
    protected void renderAdditionalGuns(RailgunTurretBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        float dist;
        if (blockEntity.isLookingAtTarget() && (dist = (float)blockEntity.getTargetDistance() - 0.4375f) > 0.0f) {
            VertexConsumer buffer = bufferSource.getBuffer(RenderType.lightning());
            Matrix4f mx4 = poseStack.last().pose();
            float y = 1.78125f;
            float z = 0.0625f;
            float lx = 0.71875f;
            float rx = 0.28125f;
            LimaColor color = blockEntity.lerpTicker(partialTick, 37.0f) >= 1.0f ? LTXIConstants.LIME_GREEN : LTXIConstants.HOSTILE_ORANGE;
            LTXIRenderUtil.renderPositionColorCuboid(buffer, mx4, lx - 0.015625f, y - 0.015625f, z, lx + 0.015625f, y + 0.015625f, z - dist, color, 0.8f, LTXIRenderUtil.ALL_SIDES);
            LTXIRenderUtil.renderPositionColorCuboid(buffer, mx4, rx - 0.015625f, y - 0.015625f, z, rx + 0.015625f, y + 0.015625f, z - dist, color, 0.8f, LTXIRenderUtil.ALL_SIDES);
        }
    }
}

