/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import liedge.limacore.client.LimaBlockEntityRenderer;
import liedge.limacore.client.LimaCoreClientUtil;
import liedge.limacore.client.model.baked.BakedItemLayer;
import liedge.limacore.client.model.baked.ItemLayerBakedModel;
import liedge.ltxindustries.blockentity.BaseTurretBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;

public abstract class TurretRenderer<BE extends BaseTurretBlockEntity>
extends LimaBlockEntityRenderer<BE> {
    private final BakedItemLayer gunsBase;
    private final BakedItemLayer gunsEmissive;
    private final BakedItemLayer swivelBase;
    private final BakedItemLayer swivelEmissive;

    protected TurretRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        ItemLayerBakedModel model = (ItemLayerBakedModel)LimaCoreClientUtil.getCustomBakedModel((ModelResourceLocation)LimaCoreClientUtil.inventoryModelPath((ItemLike)this.getModelItem()), ItemLayerBakedModel.class);
        this.gunsBase = model.getLayer("guns");
        this.gunsEmissive = model.getLayer("guns emissive");
        this.swivelBase = model.getLayer("swivel");
        this.swivelEmissive = model.getLayer("swivel emissive");
    }

    protected abstract ItemLike getModelItem();

    protected abstract double gunsYPivot();

    protected void renderAdditionalGuns(BE blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
    }

    public void render(BE blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees(((BaseTurretBlockEntity)blockEntity).lerpYRot(partialTick)));
        poseStack.translate(-0.5, 0.0, -0.5);
        this.swivelBase.putQuadsInBuffer(poseStack, bufferSource, packedLight);
        this.swivelEmissive.putQuadsInBuffer(poseStack, bufferSource, packedLight);
        poseStack.translate(0.5, this.gunsYPivot(), 0.5);
        poseStack.mulPose(Axis.XP.rotationDegrees(((BaseTurretBlockEntity)blockEntity).lerpXRot(partialTick)));
        poseStack.translate(-0.5, -this.gunsYPivot(), -0.5);
        this.gunsBase.putQuadsInBuffer(poseStack, bufferSource, packedLight);
        this.gunsEmissive.putQuadsInBuffer(poseStack, bufferSource, packedLight);
        this.renderAdditionalGuns(blockEntity, partialTick, poseStack, bufferSource, packedLight);
        poseStack.popPose();
    }

    public int getViewDistance() {
        return 128;
    }

    public boolean shouldRenderOffScreen(BE blockEntity) {
        return true;
    }

    public AABB getRenderBoundingBox(BE blockEntity) {
        return !((BaseTurretBlockEntity)blockEntity).getTargetQueue().isEmpty() ? ((BaseTurretBlockEntity)blockEntity).getTargetArea() : ((BaseTurretBlockEntity)blockEntity).getDefaultRenderBox();
    }
}

