/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.client.LTXIRenderUtil;
import liedge.ltxindustries.client.renderer.LTXIRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Matrix4f;

public class LightfragRenderer
extends EntityRenderer<Entity> {
    public LightfragRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(Entity entity, float yaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        poseStack.pushPose();
        poseStack.translate(0.0, 0.09375, 0.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(-entity.getYRot()));
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f + entity.getXRot()));
        VertexConsumer buffer = bufferSource.getBuffer(LTXIRenderTypes.POSITION_COLOR_QUADS);
        float alpha = 0.875f;
        Matrix4f mx4 = poseStack.last().pose();
        LTXIRenderUtil.renderPositionColorCuboid(buffer, mx4, -0.03125f, -0.03125f, -0.125f, 0.03125f, 0.03125f, 0.125f, LTXIConstants.LIME_GREEN, 0.875f, LTXIRenderUtil.ALL_SIDES);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(Entity entity) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

