/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import liedge.ltxindustries.client.model.entity.OrbGrenadeModel;
import liedge.ltxindustries.entity.OrbGrenadeEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;

public class OrbGrenadeRenderer
extends EntityRenderer<OrbGrenadeEntity> {
    private final OrbGrenadeModel model;

    public OrbGrenadeRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new OrbGrenadeModel(ctx.getModelSet());
    }

    public void render(OrbGrenadeEntity entity, float yaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        poseStack.pushPose();
        poseStack.translate(0.0, 0.1875, 0.0);
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - entity.getYRot()));
        this.model.animateFromEntity(entity, partialTick);
        poseStack.translate(0.0, -1.1875, 0.0);
        this.model.renderToBuffer(poseStack, bufferSource, light, entity.getGrenadeType().getColor());
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(OrbGrenadeEntity entity) {
        return OrbGrenadeModel.TEXTURE;
    }
}

