/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.client.model.entity.RocketModel;
import liedge.ltxindustries.entity.BaseRocketEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class RocketRenderer<T extends BaseRocketEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation TEXTURE = LTXIndustries.RESOURCES.textureLocation("entity", "rocket");
    private static final RenderType RENDER_TYPE = RenderType.entitySolid((ResourceLocation)TEXTURE);
    private final RocketModel model;

    public RocketRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new RocketModel(ctx.getModelSet());
    }

    public void render(T entity, float yaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        poseStack.pushPose();
        poseStack.mulPose(Axis.YP.rotationDegrees(-entity.getYRot()));
        poseStack.translate(0.0, 0.21875, 0.0);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f + entity.getXRot()));
        poseStack.translate(0.0, -1.34375, 0.0);
        VertexConsumer buffer = bufferSource.getBuffer(RENDER_TYPE);
        this.model.renderToBuffer(poseStack, buffer, 0xF000F0, OverlayTexture.NO_OVERLAY, LTXIConstants.LIME_GREEN.argb32());
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TEXTURE;
    }
}

