/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import liedge.limacore.client.renderer.LimaCoreRenderTypes;
import liedge.limacore.lib.ModResources;
import liedge.ltxindustries.entity.StickyFlameEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Matrix4f;

public class StickyFlameRenderer
extends EntityRenderer<StickyFlameEntity> {
    private static final ResourceLocation SPRITE_TEXTURE = ModResources.MC.location("block/campfire_fire");
    private final TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(SPRITE_TEXTURE);

    public StickyFlameRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(StickyFlameEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        VertexConsumer buffer = bufferSource.getBuffer(LimaCoreRenderTypes.ITEM_POS_TEX_COLOR_TRANSLUCENT);
        Matrix4f mx4 = poseStack.last().pose();
        float size = entity.tickCount < 4 ? ((float)entity.tickCount + partialTick) / 4.0f : 1.0f;
        float xz = entity.getBbWidth() / 2.0f * size;
        float y = entity.getBbHeight() * size;
        buffer.addVertex(mx4, xz, 0.0f, xz).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(this.sprite.getU1(), this.sprite.getV1()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(mx4, xz, y, xz).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(this.sprite.getU1(), this.sprite.getV0()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(mx4, -xz, y, -xz).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(this.sprite.getU0(), this.sprite.getV0()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(mx4, -xz, 0.0f, -xz).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(this.sprite.getU0(), this.sprite.getV1()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(mx4, xz, 0.0f, -xz).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(this.sprite.getU1(), this.sprite.getV1()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(mx4, xz, y, -xz).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(this.sprite.getU1(), this.sprite.getV0()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(mx4, -xz, y, xz).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(this.sprite.getU0(), this.sprite.getV0()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(mx4, -xz, 0.0f, xz).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(this.sprite.getU0(), this.sprite.getV1()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(StickyFlameEntity entity) {
        return InventoryMenu.BLOCK_ATLAS;
    }
}

