/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import liedge.limacore.client.model.baked.BakedItemLayer;
import liedge.limacore.client.model.baked.ItemLayerBakedModel;
import liedge.limacore.lib.LimaColor;
import liedge.limacore.lib.TickTimer;
import liedge.ltxindustries.client.LTXIRenderUtil;
import liedge.ltxindustries.client.model.baked.BakedRotation;
import liedge.ltxindustries.client.model.custom.TranslucentFillModel;
import liedge.ltxindustries.client.renderer.item.WeaponRenderer;
import liedge.ltxindustries.item.weapon.GrenadeLauncherItem;
import liedge.ltxindustries.item.weapon.WeaponItem;
import liedge.ltxindustries.lib.weapons.ClientWeaponControls;
import liedge.ltxindustries.registry.game.LTXIItems;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;

public class GrenadeLauncherRenderer
extends WeaponRenderer<WeaponItem> {
    private final Vector3f ornamentPivot = new Vector3f(8.0f, 9.25f, 10.0f).mul(0.0625f);
    private final TranslucentFillModel magazineFillModel = TranslucentFillModel.create(6.26f, 10.46f, 12.06f, 9.74f, 15.94f, 15.54f, Direction.Axis.Y, BakedRotation.fromAxisAngle(8.0f, 9.5f, 14.5f, 45.0f, Direction.Axis.X));
    private BakedItemLayer chamberBaseLayer;
    private BakedItemLayer chamberEmissiveLayer;
    private BakedItemLayer chamberGlassLayer;
    private float ornamentSpin0;
    private float ornamentSpin;

    GrenadeLauncherRenderer() {
    }

    public void tickItemRenderer(Player player) {
        TickTimer animationB = ClientWeaponControls.of(player).getAnimationTimerB();
        float speed = animationB.getTimerState() == TickTimer.State.RUNNING ? 0.95f * LTXIRenderUtil.sineAnimationCurve(animationB.getProgressPercent()) : 0.025f;
        this.ornamentSpin0 = this.ornamentSpin;
        this.ornamentSpin = (this.ornamentSpin + 60.0f * speed) % 360.0f;
    }

    @Override
    public void renderCrosshair(LocalPlayer player, WeaponItem weaponItem, ClientWeaponControls controls, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight, LimaColor crosshairColor) {
        int centerX = (screenWidth - 5) / 2;
        int centerY = (screenHeight - 5) / 2;
        float bloom = 4.0f * LTXIRenderUtil.animationCurveA(controls.lerpTriggerTimer(weaponItem, partialTicks));
        this.blitSprite(graphics, centerX, centerY, 5, 5, crosshairColor, HOLLOW_DOT);
        this.blitMirroredVSprite(graphics, centerX - 1, (float)(centerY - 4) - bloom, 7, 2, crosshairColor, AOE_VERTICAL);
        this.blitSprite(graphics, centerX - 1, (float)(centerY + 7) + bloom, 7, 2, crosshairColor, AOE_VERTICAL);
        this.blitSprite(graphics, (float)(centerX - 4) - bloom, centerY - 1, 2, 7, crosshairColor, AOE_HORIZONTAL);
        this.blitMirroredUSprite(graphics, (float)(centerX + 7) + bloom, centerY - 1, 2, 7, crosshairColor, AOE_HORIZONTAL);
    }

    @Override
    public void onWeaponFired(ItemStack stack, WeaponItem weaponItem, ClientWeaponControls controls) {
        controls.getAnimationTimerA().startTimer(6);
        controls.getAnimationTimerB().startTimer(10);
    }

    @Override
    protected void loadWeaponModelParts(WeaponItem item, ItemLayerBakedModel model) {
        this.chamberBaseLayer = model.getLayer("chamber base");
        this.chamberEmissiveLayer = model.getLayer("chamber emissive");
        this.chamberGlassLayer = model.getLayer("chamber glass");
    }

    @Override
    protected void renderStaticWeapon(ItemStack stack, WeaponItem item, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        LimaColor grenadeColor = GrenadeLauncherItem.getGrenadeTypeFromItem(stack).getColor();
        this.rootBaseLayer.putQuadsInBuffer(poseStack, bufferSource, light);
        this.rootEmissiveLayer.putQuadsInBuffer(poseStack, bufferSource, light);
        this.chamberBaseLayer.putQuadsInBuffer(poseStack, bufferSource, light);
        this.chamberEmissiveLayer.putQuadsInBuffer(poseStack, bufferSource, grenadeColor, light);
        this.chamberGlassLayer.putQuadsInBuffer(poseStack, bufferSource, grenadeColor, light);
        this.renderStaticMagazineFill(item, stack, poseStack, bufferSource, this.magazineFillModel, grenadeColor);
    }

    @Override
    protected void renderWeaponFirstPerson(ItemStack stack, WeaponItem item, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, float partialTick, ClientWeaponControls controls) {
        LimaColor grenadeColor = GrenadeLauncherItem.getGrenadeTypeFromItem(stack).getColor();
        float mul = LTXIRenderUtil.animationCurveA(controls.getAnimationTimerA().lerpProgressNotPaused(partialTick));
        if (mul > 0.0f) {
            poseStack.translate(0.0f, 0.0f, mul * 0.5f);
            poseStack.mulPose(Axis.XP.rotationDegrees(2.5f * mul));
        }
        poseStack.pushPose();
        poseStack.translate(this.ornamentPivot.x, this.ornamentPivot.y, this.ornamentPivot.z);
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.rotLerp((float)partialTick, (float)this.ornamentSpin0, (float)this.ornamentSpin)));
        poseStack.translate(-this.ornamentPivot.x, -this.ornamentPivot.y, -this.ornamentPivot.z);
        this.chamberBaseLayer.putQuadsInBuffer(poseStack, bufferSource, light);
        this.chamberEmissiveLayer.putQuadsInBuffer(poseStack, bufferSource, grenadeColor, light);
        poseStack.popPose();
        this.rootBaseLayer.putQuadsInBuffer(poseStack, bufferSource, light);
        this.rootEmissiveLayer.putQuadsInBuffer(poseStack, bufferSource, light);
        this.chamberGlassLayer.putQuadsInBuffer(poseStack, bufferSource, grenadeColor, light);
        this.renderAnimatedMagazineFill(item, stack, poseStack, bufferSource, this.magazineFillModel, grenadeColor, partialTick, controls);
    }

    protected WeaponItem getRenderableItem() {
        return (WeaponItem)LTXIItems.GRENADE_LAUNCHER.get();
    }
}

