/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer.item;

import liedge.limacore.lib.LimaColor;
import liedge.limacore.util.LimaEntityUtil;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.client.LTXIRenderUtil;
import liedge.ltxindustries.client.model.custom.TranslucentFillModel;
import liedge.ltxindustries.client.renderer.item.SimpleWeaponRenderer;
import liedge.ltxindustries.item.weapon.WeaponItem;
import liedge.ltxindustries.lib.weapons.ClientWeaponControls;
import liedge.ltxindustries.registry.game.LTXIItems;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;

public class HeavyPistolRenderer
extends SimpleWeaponRenderer {
    private static final float ANIMATION_FACTOR = 1.3333334f;
    private final TranslucentFillModel magazineFillModel = TranslucentFillModel.create(7.01f, 9.01f, 7.51f, 8.99f, 10.99f, 13.49f, Direction.Axis.Z);

    HeavyPistolRenderer() {
        super(17.5f, 0.375f, 6);
    }

    protected WeaponItem getRenderableItem() {
        return (WeaponItem)LTXIItems.HEAVY_PISTOL.get();
    }

    @Override
    public void renderCrosshair(LocalPlayer player, WeaponItem weaponItem, ClientWeaponControls controls, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight, LimaColor crosshairColor) {
        int centerX = (screenWidth - 1) / 2;
        int centerY = (screenHeight - 1) / 2;
        boolean aiming = LimaEntityUtil.isEntityUsingItem((LivingEntity)player, (InteractionHand)InteractionHand.MAIN_HAND);
        float triggerLerp = controls.lerpTriggerTimer(weaponItem, partialTicks);
        float bloom = 7.0f * LTXIRenderUtil.animationCurveB(triggerLerp);
        if (aiming) {
            float f = Math.min(1.0f, ((float)player.getTicksUsingItem() + partialTicks) / 3.0f);
            bloom += 3.0f - 3.0f * f;
        } else {
            bloom += 3.0f;
        }
        float xl = (float)(centerX - 6) - bloom;
        float yu = (float)(centerY - 6) - bloom;
        float xr = (float)(centerX + 2) + bloom;
        float yd = (float)(centerY + 2) + bloom;
        this.blitSprite(graphics, xl, yu, 5, 5, crosshairColor, HEAVY_PISTOL_CROSSHAIR);
        this.blitMirroredUSprite(graphics, xr, yu, 5, 5, crosshairColor, HEAVY_PISTOL_CROSSHAIR);
        this.blitMirroredUSprite(graphics, xl, yd, 5, 5, crosshairColor, HEAVY_PISTOL_CROSSHAIR);
        this.blitSprite(graphics, xr, yd, 5, 5, crosshairColor, HEAVY_PISTOL_CROSSHAIR);
        if (aiming && triggerLerp == 0.0f) {
            graphics.fill(RenderType.gui(), centerX, centerY, centerX + 1, centerY + 1, LTXIConstants.LIME_GREEN.argb32());
        }
    }

    @Override
    public TranslucentFillModel getMagazineFillModel() {
        return this.magazineFillModel;
    }

    @Override
    protected float applyAnimationCurve(float recoilA) {
        if (recoilA <= 0.125f) {
            return recoilA / 0.125f;
        }
        if (recoilA <= 0.25f) {
            return 1.0f;
        }
        return 1.0f - (recoilA - 0.25f) * 1.3333334f;
    }
}

