/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer.item;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import liedge.ltxindustries.client.renderer.item.GlowstickLauncherRenderer;
import liedge.ltxindustries.client.renderer.item.GrenadeLauncherRenderer;
import liedge.ltxindustries.client.renderer.item.HeavyPistolRenderer;
import liedge.ltxindustries.client.renderer.item.LinearFusionRenderer;
import liedge.ltxindustries.client.renderer.item.RocketLauncherRenderer;
import liedge.ltxindustries.client.renderer.item.SMGRenderer;
import liedge.ltxindustries.client.renderer.item.ShotgunRenderer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.entity.player.Player;

public final class LTXIItemRenderers {
    private static final List<ResourceManagerReloadListener> RELOAD_LISTENERS = new ObjectArrayList();
    public static final GlowstickLauncherRenderer GLOWSTICK_LAUNCHER = LTXIItemRenderers.register(new GlowstickLauncherRenderer());
    public static final SMGRenderer SUBMACHINE_GUN = LTXIItemRenderers.register(new SMGRenderer());
    public static final ShotgunRenderer SHOTGUN = LTXIItemRenderers.register(new ShotgunRenderer());
    public static final GrenadeLauncherRenderer GRENADE_LAUNCHER = LTXIItemRenderers.register(new GrenadeLauncherRenderer());
    public static final LinearFusionRenderer LINEAR_FUSION_RIFLE = LTXIItemRenderers.register(new LinearFusionRenderer());
    public static final RocketLauncherRenderer ROCKET_LAUNCHER = LTXIItemRenderers.register(new RocketLauncherRenderer());
    public static final HeavyPistolRenderer HEAVY_PISTOL = LTXIItemRenderers.register(new HeavyPistolRenderer());

    private LTXIItemRenderers() {
    }

    private static <T extends ResourceManagerReloadListener> T register(T object) {
        RELOAD_LISTENERS.add(object);
        return object;
    }

    public static void reloadAll(ResourceManager manager) {
        RELOAD_LISTENERS.forEach(o -> o.onResourceManagerReload(manager));
    }

    public static void tickValidRenderers(Player localPlayer) {
        GRENADE_LAUNCHER.tickItemRenderer(localPlayer);
    }
}

