/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import liedge.limacore.client.model.baked.BakedItemLayer;
import liedge.limacore.client.model.baked.ItemLayerBakedModel;
import liedge.limacore.lib.LimaColor;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.client.LTXIRenderUtil;
import liedge.ltxindustries.client.model.baked.BakedRotation;
import liedge.ltxindustries.client.model.custom.TranslucentFillModel;
import liedge.ltxindustries.client.renderer.LTXIRenderTypes;
import liedge.ltxindustries.client.renderer.item.SimpleWeaponRenderer;
import liedge.ltxindustries.item.weapon.WeaponItem;
import liedge.ltxindustries.lib.weapons.ClientWeaponControls;
import liedge.ltxindustries.registry.game.LTXIItems;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class LinearFusionRenderer
extends SimpleWeaponRenderer {
    private final TranslucentFillModel magazineFillModel = TranslucentFillModel.create(7.01f, -0.49f, 4.76f, 8.99f, 6.49f, 7.74f, Direction.Axis.Y, BakedRotation.fromAxisAngle(8.0f, 6.5f, 8.0f, -22.5f, Direction.Axis.X));
    private BakedItemLayer barrelGlassLayer;

    LinearFusionRenderer() {
        super(5.0f, 0.6f, 4);
    }

    @Override
    protected void loadWeaponModelParts(WeaponItem item, ItemLayerBakedModel model) {
        this.barrelGlassLayer = model.getLayer("barrel glass");
    }

    @Override
    protected void renderModelLayers(PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        super.renderModelLayers(poseStack, bufferSource, light, overlay);
        this.barrelGlassLayer.putQuadsInBuffer(poseStack, bufferSource, light);
    }

    protected WeaponItem getRenderableItem() {
        return (WeaponItem)LTXIItems.LINEAR_FUSION_RIFLE.get();
    }

    @Override
    protected TranslucentFillModel getMagazineFillModel() {
        return this.magazineFillModel;
    }

    @Override
    protected float applyAnimationCurve(float recoilA) {
        return LTXIRenderUtil.animationCurveA(recoilA);
    }

    @Override
    public void renderCrosshair(LocalPlayer player, WeaponItem weaponItem, ClientWeaponControls controls, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight, LimaColor crosshairColor) {
        int centerX = (screenWidth - 1) / 2;
        int centerY = (screenHeight - 1) / 2;
        int bracketCenterY = (screenHeight - 7) / 2;
        float bloom = 5.0f * LTXIRenderUtil.animationCurveA(controls.lerpTriggerTimer(weaponItem, partialTicks));
        this.blitSprite(graphics, (float)(centerX - 6) - bloom, bracketCenterY, 4, 7, crosshairColor, ANGLE_BRACKET);
        this.blitMirroredUSprite(graphics, (float)(centerX + 3) + bloom, bracketCenterY, 4, 7, crosshairColor, ANGLE_BRACKET);
        graphics.fill(RenderType.gui(), centerX, centerY, centerX + 1, centerY + 1, LTXIConstants.LIME_GREEN.argb32());
        int triggerTicks = controls.getTicksHoldingTrigger();
        if (triggerTicks > 0) {
            float f = Math.min(1.0f, controls.lerpTriggerTicks(partialTicks) / 10.0f);
            this.renderCrosshairChargeArc(graphics, centerX, centerY, 10, 11, f, LTXIConstants.LIME_GREEN);
            this.renderCrosshairChargeStops(graphics, centerX, centerY, 9, 12, 0.5f, 90.0f, LTXIConstants.LIME_GREEN);
            this.renderCrosshairChargeStops(graphics, centerX, centerY, 9, 12, 0.5f, 240.0f, LTXIConstants.LIME_GREEN);
        }
    }

    private void renderCrosshairChargeStops(GuiGraphics graphics, int centerX, int centerY, int startRadius, int endRadius, float barHalfWidth, float angleDegrees, LimaColor color) {
        VertexConsumer buffer = graphics.bufferSource().getBuffer(RenderType.gui());
        Matrix4f mx4 = graphics.pose().last().pose();
        float rad = LimaCoreMath.toRad((float)angleDegrees);
        float dx = Mth.cos((float)rad);
        float dy = -Mth.sin((float)rad);
        float ix = (float)centerX + dx * (float)startRadius;
        float iy = (float)centerY + dy * (float)startRadius;
        float ox = (float)centerX + dx * (float)endRadius;
        float oy = (float)centerY + dy * (float)endRadius;
        float offsetX = -dy * barHalfWidth * 2.0f;
        float offsetY = dx * barHalfWidth;
        buffer.addVertex(mx4, ix, iy - offsetY, 0.0f).setColor(color.red(), color.green(), color.blue(), 1.0f);
        buffer.addVertex(mx4, ix + offsetX, iy + offsetY, 0.0f).setColor(color.red(), color.green(), color.blue(), 1.0f);
        buffer.addVertex(mx4, ox + offsetX, oy + offsetY, 0.0f).setColor(color.red(), color.green(), color.blue(), 1.0f);
        buffer.addVertex(mx4, ox, oy - offsetY, 0.0f).setColor(color.red(), color.green(), color.blue(), 1.0f);
    }

    private void renderCrosshairChargeArc(GuiGraphics graphics, int centerX, int centerY, int innerRadius, int outerRadius, float arcLength, LimaColor color) {
        VertexConsumer buffer = graphics.bufferSource().getBuffer(LTXIRenderTypes.GUI_TRIANGLE_STRIP);
        Matrix4f mx4 = graphics.pose().last().pose();
        float endAngle = -120.0f + 210.0f * arcLength;
        for (float a = -120.0f; a <= endAngle; a += 5.0f) {
            float rad = LimaCoreMath.toRad((float)a);
            float cos = Mth.cos((float)rad);
            float sin = Mth.sin((float)rad);
            buffer.addVertex(mx4, (float)centerX + cos * (float)innerRadius, (float)centerY - sin * (float)innerRadius, 0.0f).setColor(color.red(), color.green(), color.blue(), 1.0f);
            buffer.addVertex(mx4, (float)centerX + cos * (float)outerRadius, (float)centerY - sin * (float)outerRadius, 0.0f).setColor(color.red(), color.green(), color.blue(), 1.0f);
        }
    }
}

