/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer.item;

import liedge.limacore.lib.LimaColor;
import liedge.ltxindustries.client.LTXIRenderUtil;
import liedge.ltxindustries.client.model.baked.BakedRotation;
import liedge.ltxindustries.client.model.custom.TranslucentFillModel;
import liedge.ltxindustries.client.renderer.item.SimpleWeaponRenderer;
import liedge.ltxindustries.item.weapon.WeaponItem;
import liedge.ltxindustries.lib.weapons.ClientWeaponControls;
import liedge.ltxindustries.registry.game.LTXIItems;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;

public class RocketLauncherRenderer
extends SimpleWeaponRenderer {
    private final TranslucentFillModel magazineFillModel = TranslucentFillModel.create(6.51f, 0.51f, 5.76f, 9.49f, 4.49f, 8.74f, Direction.Axis.Y, BakedRotation.fromAxisAngle(8.0f, 7.0f, 7.0f, -22.5f, Direction.Axis.X));

    RocketLauncherRenderer() {
        super(3.0f, 0.8f, 10);
    }

    @Override
    public void renderCrosshair(LocalPlayer player, WeaponItem weaponItem, ClientWeaponControls controls, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight, LimaColor crosshairColor) {
        int centerX = (screenWidth - 5) / 2;
        int centerY = (screenHeight - 5) / 2;
        float bloom = 4.0f * LTXIRenderUtil.animationCurveB(controls.lerpTriggerTimer(weaponItem, partialTicks));
        this.blitSprite(graphics, centerX, centerY, 5, 5, crosshairColor, HOLLOW_DOT);
        this.blitMirroredVSprite(graphics, centerX - 1, (float)(centerY - 4) - bloom, 7, 2, crosshairColor, AOE_VERTICAL);
        this.blitSprite(graphics, centerX - 1, (float)(centerY + 7) + bloom, 7, 2, crosshairColor, AOE_VERTICAL);
        this.blitSprite(graphics, (float)(centerX - 4) - bloom, centerY - 1, 2, 7, crosshairColor, AOE_HORIZONTAL);
        this.blitMirroredUSprite(graphics, (float)(centerX + 7) + bloom, centerY - 1, 2, 7, crosshairColor, AOE_HORIZONTAL);
    }

    protected WeaponItem getRenderableItem() {
        return (WeaponItem)LTXIItems.ROCKET_LAUNCHER.get();
    }

    @Override
    protected TranslucentFillModel getMagazineFillModel() {
        return this.magazineFillModel;
    }

    @Override
    protected float applyAnimationCurve(float recoilA) {
        return LTXIRenderUtil.animationCurveB(recoilA);
    }
}

