/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import liedge.limacore.client.model.baked.ItemLayerBakedModel;
import liedge.limacore.lib.LimaColor;
import liedge.limacore.util.LimaEntityUtil;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.client.LTXIRenderUtil;
import liedge.ltxindustries.client.model.baked.BakedRotation;
import liedge.ltxindustries.client.model.custom.TranslucentFillModel;
import liedge.ltxindustries.client.renderer.item.WeaponRenderer;
import liedge.ltxindustries.item.weapon.WeaponItem;
import liedge.ltxindustries.lib.weapons.ClientWeaponControls;
import liedge.ltxindustries.registry.game.LTXIItems;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class SMGRenderer
extends WeaponRenderer<WeaponItem> {
    private final TranslucentFillModel magazineFillModel = TranslucentFillModel.create(7.01f, 1.52f, 6.01f, 8.99f, 7.5f, 8.49f, Direction.Axis.Y, BakedRotation.fromAxisAngle(8.0f, 9.0f, 13.5f, -22.5f, Direction.Axis.X));

    SMGRenderer() {
    }

    protected WeaponItem getRenderableItem() {
        return (WeaponItem)LTXIItems.SUBMACHINE_GUN.get();
    }

    @Override
    public void renderCrosshair(LocalPlayer player, WeaponItem weaponItem, ClientWeaponControls controls, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight, LimaColor crosshairColor) {
        float baseBloom;
        int centerX = (screenWidth - 5) / 2;
        int centerY = (screenHeight - 5) / 2;
        if (LimaEntityUtil.isEntityUsingItem((LivingEntity)player, (InteractionHand)InteractionHand.MAIN_HAND)) {
            float f = Math.min(1.0f, ((float)player.getTicksUsingItem() + partialTicks) / 3.0f);
            baseBloom = 3.0f - 3.0f * f;
        } else {
            baseBloom = 3.0f;
        }
        float bloom = baseBloom + 2.0f * (controls.isTriggerHeld() ? LTXIRenderUtil.sineAnimationCurve(partialTicks) : 0.0f);
        this.blitSprite(graphics, centerX, centerY, 5, 5, crosshairColor, HOLLOW_DOT);
        this.blitSprite(graphics, (float)(centerX - 4) - bloom, centerY - 4, 6, 13, crosshairColor, CIRCLE_BRACKET);
        this.blitMirroredUSprite(graphics, (float)(centerX + 3) + bloom, centerY - 4, 6, 13, crosshairColor, CIRCLE_BRACKET);
    }

    @Override
    public void onWeaponFired(ItemStack stack, WeaponItem weaponItem, ClientWeaponControls controls) {
    }

    @Override
    protected void loadWeaponModelParts(WeaponItem item, ItemLayerBakedModel model) {
    }

    @Override
    protected void renderStaticWeapon(ItemStack stack, WeaponItem item, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        this.rootBaseLayer.putQuadsInBuffer(poseStack, bufferSource, light);
        this.rootEmissiveLayer.putQuadsInBuffer(poseStack, bufferSource, light);
        this.renderStaticMagazineFill(item, stack, poseStack, bufferSource, this.magazineFillModel, LTXIConstants.LIME_GREEN);
    }

    @Override
    protected void renderWeaponFirstPerson(ItemStack stack, WeaponItem item, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, float partialTick, ClientWeaponControls controls) {
        if (controls.isTriggerHeld()) {
            poseStack.translate(0.0f, 0.0f, 0.09375f * LTXIRenderUtil.sineAnimationCurve(partialTick));
        }
        this.rootBaseLayer.putQuadsInBuffer(poseStack, bufferSource, light);
        this.rootEmissiveLayer.putQuadsInBuffer(poseStack, bufferSource, light);
        this.renderAnimatedMagazineFill(item, stack, poseStack, bufferSource, this.magazineFillModel, LTXIConstants.LIME_GREEN, partialTick, controls);
    }
}

