/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.client.renderer.item;

import liedge.limacore.lib.LimaColor;
import liedge.ltxindustries.client.LTXIRenderUtil;
import liedge.ltxindustries.client.model.baked.BakedRotation;
import liedge.ltxindustries.client.model.custom.TranslucentFillModel;
import liedge.ltxindustries.client.renderer.item.SimpleWeaponRenderer;
import liedge.ltxindustries.item.weapon.WeaponItem;
import liedge.ltxindustries.lib.weapons.ClientWeaponControls;
import liedge.ltxindustries.registry.game.LTXIItems;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Direction;

public class ShotgunRenderer
extends SimpleWeaponRenderer {
    private final TranslucentFillModel magazineFillModel = TranslucentFillModel.create(6.76f, 2.76f, 3.51f, 9.24f, 8.74f, 5.99f, Direction.Axis.Y, BakedRotation.fromAxisAngle(8.0f, 9.0f, 13.5f, -22.5f, Direction.Axis.X));

    ShotgunRenderer() {
        super(5.0f, 0.75f, 5);
    }

    protected WeaponItem getRenderableItem() {
        return (WeaponItem)LTXIItems.SHOTGUN.get();
    }

    @Override
    public void renderCrosshair(LocalPlayer player, WeaponItem weaponItem, ClientWeaponControls controls, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight, LimaColor crosshairColor) {
        int centerX = (screenWidth - 1) / 2;
        int centerY = (screenHeight - 13) / 2;
        float bloom = 3.0f + 4.0f * LTXIRenderUtil.animationCurveB(controls.lerpTriggerTimer(weaponItem, partialTicks));
        this.blitSprite(graphics, (float)(centerX - 6) - bloom, centerY, 6, 13, crosshairColor, CIRCLE_BRACKET);
        this.blitMirroredUSprite(graphics, (float)(centerX + 1) + bloom, centerY, 6, 13, crosshairColor, CIRCLE_BRACKET);
    }

    @Override
    public TranslucentFillModel getMagazineFillModel() {
        return this.magazineFillModel;
    }

    @Override
    protected float applyAnimationCurve(float recoilA) {
        return LTXIRenderUtil.animationCurveA(recoilA);
    }
}

